


import random
from turtle import end_fill
from numba.typed import List
import warnings
from numba import njit
import pynndescent
import numpy as np
import operator



def mat_flow_rank(adj_list,vlist,steps):

    n=len(vlist)
    k=len(adj_list[0])

    v_cover=np.ones((n))

    in_list=[[] for _ in range(n)]
    for i in range(n):
        for j in adj_list[i]:
            in_list[j].append(i)


    #Now change v_cover:
    for ell in range(steps):

        v_cover_n=np.zeros((n))
        for i in range(n):
            v_cover_n[i]=1/k*sum(v_cover[in_list[i]])

        v_cover=v_cover_n.copy()

    
    return v_cover






@njit
def T_PR(adj_list,walk_len_c1,c_const):

    n=len(adj_list)

    walk_len=walk_len_c1 #Changed here!


    v_cover=np.zeros((n))

    t=0
    for i in range(n):
        curr=i

        for j in range(c_const):
            k=len(adj_list[curr])
            pos=random.randint(0,k-1)
            t=t+1
            x=adj_list[curr][pos]
            curr=x



        for j in range(walk_len-c_const): 
            k=len(adj_list[curr])

            if(k<1):
                print("anarchy")
                break
        
            pos=random.randint(0,k-1)
            t=t+1
            x=adj_list[curr][pos]
            v_cover[x]=v_cover[x]+1
            curr=x

    return v_cover


#@njit
def mat_PR(mat_list,wt_list,walk_len_c1):

    n=len(mat_list)
    walk_len=int(np.log2(n)*walk_len_c1)

    vec=np.ones((n))


    for ell in range(walk_len):

        vec1=np.zeros(n)

        for i in range(n):
            t0=0
            for j in mat_list[i]:
                t0=t0+vec[j]/wt_list[j]
            
        vec=vec1


    return vec

@njit
def short_walk(adj_list,v_cover,v):

    vset=[v]
    times=1

    for times in range(times):
        curr=v
        stop=0
        t=0
        lent=0
        while(stop!=-1): 
            stepper=[]


            for ell in adj_list[curr]:

                if(v_cover[ell]>v_cover[curr]):
                     stepper.append(ell)

            k1=len(stepper)

            if(k1==0):
                stop=-1
            
            else:
                pos1=random.randint(0,k1-1)
                #print(v,lent,0,k1-1,pos1)
                curr=stepper[pos1]
                vset.append(curr)
                t=t+1
                

            lent+=1

        
    return vset,lent





###-------------------------------------------------------


# NeighborRank
def flow_calc_ng(adj_list,vlist,walk_len_c1,c_const):
    
    n=len(adj_list)

    v_cover=np.zeros(n)

    v_cover=mat_flow_rank(adj_list,vlist,int(walk_len_c1))





    xaxis=[i for i in range(n)]

    # plt.scatter(xaxis,v_cover,c='green',s=2)
    # plt.show()

    rank=np.zeros((n))

    for v in vlist:

        sc=0
        t=0
        sset=[]
        for ell in adj_list[v]:       
            if(v_cover[ell]>v_cover[v]):
            
              t=t+1
              sc=sc+v_cover[ell]
              #sc=sc+v_cover[v]/v_cover[ell]




        if(sc!=0 and t!=0):
            sc=sc/t
        else:
            sc=v_cover[v]

        # elif(sc!=0 and t==0):
        #     sc=1
        # else:        
        #      sc=v_cover[t]


        rank[v]=v_cover[v]/sc

        #rank[v]=sc


    

    v_cover_order=np.zeros((n,2))
    v_cover_order[:,0]=rank
    v_cover_order[:,1]=xaxis


    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True) 
    v_cover_order=np.array(v_cover_order)

    # print(min(rank),max(rank))

    #Priting the final scores
    # plt.scatter(xaxis,v_cover_order[:,0],c='green',s=2)
    # plt.show()


    return v_cover_order
        
    


def FLOW_ng(edge_list,vlist,walk_len_c1,c_const=0):

    n=len(vlist)
    adj_list1=[[] for i in range(n)]
    for (u,v) in edge_list:
        adj_list1[u].append(v)

    adj_list=List(List(x) for x in adj_list1)

    v_cover_order=flow_calc_ng(adj_list,vlist,walk_len_c1,c_const)


    return v_cover_order



##--------FLow_ng_naive


def flow_calc_ng_naive(adj_list,vlist,walk_len_c1,c_const):
    
    n=len(adj_list)

    v_cover=np.zeros(n)

    times1=1000
    for ell in range(times1):

        v_cover1=T_PR(adj_list,walk_len_c1,c_const)
        v_cover=v_cover+v_cover1



    xaxis=[i for i in range(n)]

    # plt.scatter(xaxis,v_cover,c='green',s=2)
    # plt.show()

    rank=np.zeros((n))

    for v in vlist:

        sc=0
        t=0
        sset=[]
        for ell in adj_list[v]:       
            t=t+1
            sc=sc+v_cover[ell]


        if(sc!=0 and t!=0):
            sc=sc/t
        else:
            sc=v_cover[v]


        rank[v]=v_cover[v]/sc


    v_cover_order=np.zeros((n,2))
    v_cover_order[:,0]=rank
    v_cover_order[:,1]=xaxis


    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True) 
    v_cover_order=np.array(v_cover_order)


    return v_cover_order


def FLOW_ng_naive(edge_list,vlist,walk_len_c1,c_const=0):

    n=len(vlist)
    adj_list1=[[] for i in range(n)]
    for (u,v) in edge_list:
        adj_list1[u].append(v)

    adj_list=List(List(x) for x in adj_list1)

    v_cover_order=flow_calc_ng_naive(adj_list,vlist,walk_len_c1,c_const)


    return v_cover_order



##-----------------------------------------------
## FLOW 2-hop-neighbor (N2-Rank-mod)

def flow_calc_ng2(adj_list,vlist,walk_len_c1,c_const):
    
    n=len(adj_list)

    v_cover=np.zeros(n)

    v_cover=mat_flow_rank(adj_list,vlist,int(walk_len_c1))

    # times1=200
    # for ell in range(times1):

    #     v_cover1=T_PR(adj_list,walk_len_c1,c_const)
    #     v_cover=v_cover+v_cover1



    xaxis=[i for i in range(n)]

    # plt.scatter(xaxis,v_cover,c='green',s=2)
    # plt.show()

    rank=np.zeros((n))

    for v in vlist:

        sc=0
        t=0
        sset=[]
        hmap={}
        for ell in adj_list[v]:

            if(v_cover[ell]>v_cover[v]):

                for ell1 in adj_list[ell]:

                    if(v_cover[ell1]>v_cover[ell]):

                        for ell2 in adj_list[ell1]:
                            
                            if(v_cover[ell2]>v_cover[ell1]):

                                if(ell1 in hmap):
                                    hmap[ell1]=hmap[ell1]+1
                                else:
                                    hmap[ell1]=1


        tmin=0
        for ell in hmap:
            if(hmap[ell]>tmin):
                tmin=hmap[ell]
            

        if(len(hmap)>0):
            for ell in hmap:
                if(hmap[ell]>=tmin):
                    sc=sc+(hmap[ell]*v_cover[ell])
                    t=t+hmap[ell]

        else:

            for ell in adj_list[v]:
                if(v_cover[ell]>v_cover[v]): 

                    sc=sc+v_cover[ell]
                    t=t+1





            # if(hmap[ell]>=min(tmin//2,tmin-1) and v_cover[ell]>v_cover[v]):
            #     t=t+1
                
            #     sc=sc+v_cover[ell]
                
            #     #sset.append(v_cover[ell])
            #     #sc=sc+v_cover[v]/v_cover[ell]




        if(sc!=0 and t!=0):
            sc=sc/t
        else:
            sc=v_cover[v]


        rank[v]=v_cover[v]/sc

        #rank[v]=sc


    

    v_cover_order=np.zeros((n,2))
    v_cover_order[:,0]=rank
    v_cover_order[:,1]=xaxis


    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True) 
    v_cover_order=np.array(v_cover_order)

    # print(min(rank),max(rank))

    #Priting the final scores
    # plt.scatter(xaxis,v_cover_order[:,0],c='green',s=2)
    # plt.show()


    return v_cover_order


def FLOW_ng2(edge_list,vlist,walk_len_c1,c_const=0):

    n=len(vlist)
    adj_list1=[[] for i in range(n)]
    for (u,v) in edge_list:
        adj_list1[u].append(v)

    adj_list=List(List(x) for x in adj_list1)

    v_cover_order=flow_calc_ng2(adj_list,vlist,walk_len_c1,c_const)


    return v_cover_order


###----- Flow_ng_propagate: RN-Rank



def flow_calc_ng_prop(adj_list,vlist,walk_len_c1,c_const):
    
    n=len(adj_list)

    v_cover_order1=flow_calc_ng(adj_list,vlist,walk_len_c1,c_const)

    v_cover_order1=np.array(v_cover_order1)

    v_cover_order2=sorted(v_cover_order1,key=operator.itemgetter(1),reverse=False)

    v_cover=np.array(v_cover_order2)[:,0]

    print(v_cover.shape)



    xaxis=[i for i in range(n)]

    # plt.scatter(xaxis,v_cover,c='green',s=2)
    # plt.show()

    rank=np.zeros((n))

    for v in vlist:

        sc=0
        t=0
        sset=[]
        for ell in adj_list[v]:       
            if(v_cover[ell]>v_cover[v]):
            
              t=t+1
              sc=sc+v_cover[ell]
              #sc=sc+v_cover[v]/v_cover[ell]




        if(sc!=0 and t!=0):
            sc=sc/t
        else:
            sc=v_cover[v]

        # elif(sc!=0 and t==0):
        #     sc=1
        # else:        
        #      sc=v_cover[t]


        rank[v]=v_cover[v]/sc

        #rank[v]=sc


    

    v_cover_order=np.zeros((n,2))
    v_cover_order[:,0]=rank
    v_cover_order[:,1]=xaxis


    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True) 
    v_cover_order=np.array(v_cover_order)

    # print(min(rank),max(rank))

    #Priting the final scores
    # plt.scatter(xaxis,v_cover_order[:,0],c='green',s=2)
    # plt.show()


    return v_cover_order


def FLOW_ng_prop(edge_list,vlist,walk_len_c1,c_const=0):

    n=len(vlist)
    adj_list1=[[] for i in range(n)]
    for (u,v) in edge_list:
        adj_list1[u].append(v)

    adj_list=List(List(x) for x in adj_list1)

    v_cover_order=flow_calc_ng_prop(adj_list,vlist,walk_len_c1,c_const)


    return v_cover_order




##--------- 2 hop simple. N2-Rank
def flow_calc_ng2hopsimple(adj_list,vlist,walk_len_c1,c_const):
    
    n=len(adj_list)

    v_cover=np.zeros(n)

    times1=200
    for ell in range(times1):

        v_cover1=T_PR(adj_list,walk_len_c1,c_const)
        v_cover=v_cover+v_cover1



    xaxis=[i for i in range(n)]

    # plt.scatter(xaxis,v_cover,c='green',s=2)
    # plt.show()

    rank=np.zeros((n))

    for v in vlist:

        sc=0
        t=0
        sset=[]
        hmap={}
        for ell in adj_list[v]:

            if(v_cover[ell]>v_cover[v]):
                sc=sc+v_cover[ell]
                t=t+1

            for ell1 in adj_list[ell]:

                if(v_cover[ell1]>v_cover[v]):
                    sc=sc+v_cover[ell1]
                    t=t+1

        if(sc!=0 and t!=0):
            sc=sc/t
        else:
            sc=v_cover[v]


        rank[v]=v_cover[v]/sc

        #rank[v]=sc


    

    v_cover_order=np.zeros((n,2))
    v_cover_order[:,0]=rank
    v_cover_order[:,1]=xaxis


    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True) 
    v_cover_order=np.array(v_cover_order)

    # print(min(rank),max(rank))

    #Priting the final scores
    # plt.scatter(xaxis,v_cover_order[:,0],c='green',s=2)
    # plt.show()


    return v_cover_order


def FLOW_ng2hopsimple(edge_list,vlist,walk_len_c1,c_const=0):

    n=len(vlist)
    adj_list1=[[] for i in range(n)]
    for (u,v) in edge_list:
        adj_list1[u].append(v)

    adj_list=List(List(x) for x in adj_list1)

    v_cover_order=flow_calc_ng2hopsimple(adj_list,vlist,walk_len_c1,c_const)


    return v_cover_order

    



