import networkx as nx
import sknetwork
import numpy as np
import operator

from sknetwork.ranking import PageRank
from sknetwork.ranking import Betweenness
from sknetwork.ranking import Closeness
from sknetwork.ranking import Katz
from sknetwork.topology import get_core_decomposition
from sknetwork.utils import directed2undirected




#Onion core decomposition
def cores(edge_list,vlist,PX,n):

    G=nx.from_edgelist(edge_list)
    G.remove_edges_from(nx.selfloop_edges(G))
    od_layers=nx.onion_layers(G)


    core_order=np.zeros((n,2))
    for i in range(n):
        core_order[i,0]=od_layers[i]
        core_order[i,1]=i

    #print(n,len(od_layers))


    core_order=sorted(core_order, key=operator.itemgetter(0),reverse=True)
    core_order=np.array(core_order)

    

    return core_order


#PageRank
def pagerank_5(edge_list,vlist,PX,n):

    GG=sknetwork.data.from_edge_list(edge_list,directed=True)

    PR = PageRank(damping_factor=0.5)
    vorder = PR.fit_predict(GG)

    #print(len(vorder),vorder)

    xaxis=[i for i in range(n)]
    v_cover_order=np.zeros((n,2))

    v_cover_order[:,0]=vorder
    v_cover_order[:,1]=xaxis

    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True)
    v_cover_order=np.array(v_cover_order)

    return v_cover_order

def pagerank_85(edge_list,vlist,PX,n):

    GG=sknetwork.data.from_edge_list(edge_list,directed=True)

    PR = PageRank(damping_factor=0.85)
    vorder = PR.fit_predict(GG)

    #print(len(vorder),vorder)

    xaxis=[i for i in range(n)]
    v_cover_order=np.zeros((n,2))

    v_cover_order[:,0]=vorder
    v_cover_order[:,1]=xaxis

    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True)
    v_cover_order=np.array(v_cover_order)

    return v_cover_order

def pagerank_99(edge_list,vlist,PX,n):

    GG=sknetwork.data.from_edge_list(edge_list,directed=True)

    PR = PageRank(damping_factor=0.99)
    vorder = PR.fit_predict(GG)

    #print(len(vorder),vorder)

    xaxis=[i for i in range(n)]
    v_cover_order=np.zeros((n,2))

    v_cover_order[:,0]=vorder
    v_cover_order[:,1]=xaxis

    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True)
    v_cover_order=np.array(v_cover_order)

    return v_cover_order



#In-degree centrality
def deg_centrality(edge_list,vlist,PX,n):

    n=len(vlist)
    degs=np.zeros((n))

    for u,v in edge_list:
        degs[v]+=1

    xaxis=[i for i in range(n)]

    deg_order=np.zeros((n,2))

    deg_order[:,0]=degs
    deg_order[:,1]=xaxis

    deg_order=sorted(deg_order, key=operator.itemgetter(0),reverse=True)
    deg_order=np.array(deg_order)

    return deg_order





#Betweenness score
def between_score(edge_list,vlist,PX,n):

    GG=sknetwork.data.from_edge_list(edge_list,directed=True)
    betweenness = Betweenness()
    scores = betweenness.fit_transform(GG)

    xaxis=[i for i in range(n)]
    v_cover_order=np.zeros((n,2))

    v_cover_order[:,0]=scores
    v_cover_order[:,1]=xaxis

    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=False)
    v_cover_order=np.array(v_cover_order)

    return v_cover_order



#Closeness centrality
def closeness_score(edge_list,vlist,PX,n):

    GG=sknetwork.data.from_edge_list(edge_list,directed=True)
    closeness = Closeness()
    scores = closeness.fit_predict(GG) 

    xaxis=[i for i in range(n)]
    v_cover_order=np.zeros((n,2))

    v_cover_order[:,0]=scores
    v_cover_order[:,1]=xaxis

    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True)
    v_cover_order=np.array(v_cover_order)

    return v_cover_order

#Katz centrality
def Katz_score(edge_list,vlist,PX,n):
    GG=sknetwork.data.from_edge_list(edge_list,directed=True)
    katz = Katz()
    scores = katz.fit_predict(GG)

    xaxis=[i for i in range(n)]
    v_cover_order=np.zeros((n,2))

    v_cover_order[:,0]=scores
    v_cover_order[:,1]=xaxis

    v_cover_order=sorted(v_cover_order, key=operator.itemgetter(0),reverse=True)
    v_cover_order=np.array(v_cover_order)

    return v_cover_order





def ADVHITS(edge_list,vlist):

    G1= nx.Graph()
    G1.add_nodes_from(vlist)
    m=len(edge_list)

    for i in range(m):
        u,v=edge_list[i]
        G1.add_edge(u,v)

    res=nx.hits(G1, max_iter=100, tol=1e-08, nstart=None, normalized=True)

    return res






