from sklearn.decomposition import PCA
import pynndescent
import numpy as np


def dir_KNN_graph(X,kchoice,dimension=0):


    if(dimension>0):
        transformer = PCA(n_components=dimension)
        X= transformer.fit_transform(X)


    n=X.shape[0]
    index = pynndescent.NNDescent(X)
    index.prepare()
    kchoice1=kchoice+1
    neighbors = index.query(X,k=kchoice1)
    indices = neighbors[0]
    knn_list=indices[:,1:]
    knn_list=np.array(knn_list)



    checked=np.zeros((n))

    edge_list=[]
    vlist=[]

    hashmap={}
    c=0
    i=0

    for i in range(n):
        for j in range(kchoice):

            u=i
            v=knn_list[i,j]

            if (u,v) in hashmap:
                c=c
            else:
                edge_list.append((u,v))        
                hashmap[(u,v)]=1
                c=c+1

            if(checked[u]==0):
                vlist.append(u)
            
            if(checked[v]==0):
                vlist.append(v)

            checked[u]+=1
            checked[v]+=1

        i=i+1

    return edge_list,vlist


