from orchestrator_maze_implementation.utils.maze_utils.maze_generation import MazeGenerator
from orchestrator_maze_implementation.utils.maze_utils.maze_wrapper import MazeWrapper

def create_maze_by_uuid(uuid: str):
    """Create a maze by UUID with MazeWrapper"""
    print(f"Creating a maze by UUID: {uuid}...")
    generator = MazeGenerator.find_maze_by_uuid(uuid, directory='./orchestrator_maze_implementation/mazes')
    maze_wrapper = MazeWrapper(generator)
    return maze_wrapper

def create_simple_maze():
    """Create a simple 8x8 maze with MazeWrapper"""
    print("Creating a simple 8x8 maze...")
    generator = MazeGenerator(maze_size=8)
    maze_wrapper = MazeWrapper(generator)
    
    print(f"Starting position: {maze_wrapper.get_agent_position()}")
    
    # Print maze preview
    print("\nMaze Preview:")
    maze_wrapper.print_maze_with_agent()
    
    return maze_wrapper