"""
Configuration file for the multi-agent maze runner workflow.

This file centralizes all tunable parameters for workflow control, visualization,
output, and display options. Adjust these values to run experiments, ablation tests,
or to customize the behavior and appearance of the maze navigation system.

Import this module where configuration values are needed.
"""

########################################################################################
# Setup Configurations
########################################################################################

# Workflow configuration
RECURSION_LIMIT = 50000
NUM_TURN_ITERATIONS = 5  # Number of full turns (plan executions) before calling orchestration agent

# Visualization configuration
FIGURE_SIZE = (16, 8)
FINAL_DISPLAY_DURATION = 5  # seconds to show final result
MESSAGE_HISTORY_LIMIT = 8
ENABLE_MAZE_VISUALIZATION = True

# Output configuration
SAVE_IMAGES = True
FINAL_MAZE_FILENAME = "final_maze_state.png"

# Display toggles for maze visualization
SHOW_PATH = True
SHOW_AGENT = True
SHOW_START = True
SHOW_FAILED_MOVES = True
SHOW_MARKED_DEAD_ENDS = True


########################################################################################
# Agent Configurations
########################################################################################

## GLOBAL CONFIGURATIONS
NUM_EXECUTION_AGENTS = 2
STEPS_PER_AGENT = 1 # Number of steps each agent takes before rotating to the next agent

## EXECUTION AGENT CONFIGURATIONS
EXECUTION_MODEL = 'gpt-4.1-nano'
EXECUTION_TEMPERATURE = 0.1

## PLANNING AGENT CONFIGURATIONS
PLAN_MODEL = 'gpt-4.1-nano'
PLAN_TEMPERATURE = 0.1

## ORCHESTRATION AGENT CONFIGURATIONS
ORCHESTRATION_MODEL = 'gpt-4.1'
ORCHESTRATION_TEMPERATURE = 0.1
