from langchain_core.messages import SystemMessage, HumanMessage, AIMessage, ToolMessage
from orchestrator_maze_implementation.state.maze_state import MazeState
from orchestrator_maze_implementation.tools.basic_tool_functions import MazeTools

def display_conversation_summary(state: MazeState):
    """Display a summary of the agent's conversation history"""
    if not state["messages"]:
        print("No conversation history available")
        return
    
    print(f"\nCONVERSATION SUMMARY ({len(state['messages'])} messages)")
    print("=" * 50)
    
    # Count message types
    system_msgs = sum(1 for msg in state["messages"] if isinstance(msg, SystemMessage))
    user_msgs = sum(1 for msg in state["messages"] if isinstance(msg, HumanMessage))
    assistant_msgs = sum(1 for msg in state["messages"] if isinstance(msg, AIMessage))
    tool_msgs = sum(1 for msg in state["messages"] if isinstance(msg, ToolMessage))
    
    print(f"Message breakdown:")
    print(f"   System messages: {system_msgs}")
    print(f"   User messages: {user_msgs}")
    print(f"   Assistant messages: {assistant_msgs}")
    print(f"   Tool messages: {tool_msgs}")
    
    # Show recent messages
    print(f"\nRecent conversation:")
    for msg in state["messages"][-3:]:
        if isinstance(msg, (SystemMessage, HumanMessage, AIMessage)):
            role = msg.__class__.__name__
            content = msg.content[:100] + "..." if len(msg.content) > 100 else msg.content
            print(f"   {role}: {content}")
    
    print("=" * 50)