#!/usr/bin/env python3
"""
Test script for the Redundant Token Eviction via Self-summarization algorithm.
"""

import torch
from transformers import AutoTokenizer, AutoModel
# from verl.workers.rollout.vllm_rollout.redundant_token_eviction import run_eviction_algorithm
from verl.workers.rollout.vllm_rollout.random_token_eviction import run_eviction_algorithm
import os

os.environ['HF_HOME'] = 'NONE.cache/huggingface'


def test_with_example():
    tokenizer = AutoTokenizer.from_pretrained("Qwen/Qwen3-4B")
    model = AutoModel.from_pretrained("Qwen/Qwen3-4B", torch_dtype=torch.bfloat16, attn_implementation="eager").to("cuda:5")

    sentence = "<think>\nOkay, so I need to find the sum over all triples (a, b, c) of non-negative integers where a + b + c is even, of the term 1/(2^a 3^b 5^c). The answer should be expressed as a reduced fraction m/n and then find m + n. Alright, let me start by understanding the problem.\n\nFirst, the set S consists of all triples (a, b, c) where each of a, b, c is a non-negative integer (so they can be 0, 1, 2, ...), and their sum a + b + c is even. So, I need to compute the sum:\n\nSum_{(a,b,c) ∈ S} 1/(2^a 3^b 5^c)\n\nHmm. Let me think about generating functions. Since each variable a, b, c is independent except for the condition that their sum is even. Maybe I can use generating functions to model this.\n\nFirst, I know that for each variable, the generating function for the sum over all non-negative integers is a geometric series. For example, for variable a, the generating function would be 1 + x/2 + x²/2² + x³/2³ + ... = 1/(1 - x/2). Similarly for b, it would be 1/(1 - x/3), and for c, 1/(1 - x/5). But here, the problem is not about a single variable, but about the product of all three variables, with the condition that their sum is even.\n\nAlternatively, maybe I can think about the entire generating function without the parity condition, and then subtract the sum where the parity is odd? Or perhaps use a trick with generating functions that accounts for parity.\n\nAlternatively, since the sum a + b + c is even, maybe I can consider splitting the generating function into two parts: one where a + b + c is even and one where it's odd, and then take the even part. There's a standard trick for generating functions where you can use (1 + (-1)^k) to pick out even or odd terms. Wait, that might be useful here.\n\nLet me recall that. For generating functions, if I want to compute the sum over all terms where the exponent is even, I can take the generating function evaluated at 1 and at -1 and average them. For example, if I have a generating function G(x) = sum_{n} a_n x^n, then the sum over even n of a_n is (G(1) + G(-1))/2. Similarly, the sum over odd n is (G(1) - G(-1))/2. But here, the exponents are not directly the sum, but rather the sum of three variables. Maybe I need to adjust for that.\n\nAlternatively, maybe I can model the generating function where each variable contributes a term, and then use the generating function for the sum. Let me think again.\n\nLet me consider the generating function for the sum over all triples (a, b, c) of (1/(2^a 3^b 5^c)) * x^{a + b + c}. Then the coefficient of x^k in this generating function would be the sum over all triples with a + b + c = k of 1/(2^a 3^b 5^c). But we need the sum over all even k of this coefficient. So if I denote this generating function as F(x), then the desired sum would be (F(1) + F(-1))/2.\n\nYes! That seems like a good approach. So let me formalize this.\n\nLet me define F(x) = sum_{a, b, c ≥ 0} (1/(2^a 3^b 5^c)) x^{a + b + c}.\n\nThen the sum we need is [F(1) + F(-1)] / 2.\n\nSo first, compute F(x). Since the variables are independent, we can express F(x) as the product of the generating functions for each variable.\n\nFor variable a: sum_{a ≥ 0} (1/2^a) x^a = 1 / (1 - x/2).\n\nSimilarly for variable b: sum_{b ≥ 0} (1/3^b) x^b = 1 / (1 - x/3).\n\nFor variable c: sum_{c ≥ 0} (1/5^c) x^c = 1 / (1 - x/5).\n\nTherefore, F(x) = [1 / (1 - x/2)] * [1 / (1 - x/3)] * [1 / (1 - x/5)].\n\nTherefore, the desired sum is [F(1) + F(-1)] / 2.\n\nSo compute F(1) and F(-1):\n\nFirst, F(1) is [1 / (1 - 1/2)] * [1 / (1 - 1/3)] * [1 / (1 - 1/5)].\n\nCalculating each term:\n\n1 / (1 - 1/2) = 1 / (1/2) = 2.\n\n1 / (1 - 1/3) = 1 / (2/3) = 3/2.\n\n1 / (1 - 1/5) = 1 / (4/5) = 5/4.\n\nMultiplying them together: 2 * (3/2) * (5/4) = (2 * 3 * 5) / (2 * 4) ) = (30)/8 = 15/4.\n\nSo F(1) = 15/4.\n\nNow compute F(-1):\n\nF(-1) = [1 / (1 - (-1)/2)] * [1 / (1 - (-1)/3)] * [1 / (1 - (-1)/5)].\n\nSimplify each denominator:\n\nFor the first term: 1 - (-1)/2 = 1 + 1/2 = 3/2. So 1 / (3/2) = 2/3.\n\nSecond term: 1 - (-1)/3 = 1 + 1/3 = 4/3. So 1 / (4/3) = 3/4.\n\nThird term: 1 - (-1)/5 = 1 + 1/5 = 6/5. So 1 / (6/5) = 5/6.\n\nMultiply them together: (2/3) * (3/4) * (5/6).\n\nSimplify step by step:\n\n(2/3)*(3/4) = (2/4) = 1/2.\n\nThen 1/2 * 5/6 = 5/12.\n\nSo F(-1) = 5/12.\n\nTherefore, the desired sum is [F(1) + F(-1)] / 2 = [15/4 + 5/12]/2.\n\nCompute 15/4 + 5/12:\n\nConvert to common denominator, which is 12. 15/4 = 45/12, so 45/12 + 5/12 = 50/12 = 25/6.\n\nThen divide by 2: (25/6)/2 = 25/12.\n\nWait, so the sum is 25/12?\n\nBut wait, let me check again. Because 15/4 is 4.5, 5/12 is approx 0.416..., so adding them is approx 4.916..., divided by 2 is approx 2.458..., and 25/12 is approx 2.083... Wait, that can't be right. Wait, 25/12 is about 2.083, but according to my calculation:\n\nWait, 15/4 is 3.75, 5/12 is approx 0.416, so total is approx 4.166..., divided by 2 is approx 2.083, which is 25/12. But that seems contradictory? Wait, no, 15/4 is 3.75, and 5/12 is approx 0.416, sum is approx 4.166, which is 25/6? Wait, no:\n\nWait 15/4 + 5/12. Let me recalculate.\n\n15/4 is equal to (15 * 3)/12 = 45/12. 45/12 + 5/12 is 50/12, which is 25/6. So 25/6 divided by 2 is 25/12. Yes, 25/12 is approximately 2.083...\n\nBut let me check whether this answer is correct. Let me think about whether the generating function approach is correct.\n\nSo, the generating function F(x) is the generating function for all triples (a,b,c) with weights 1/(2^a 3^b 5^c) and exponents a + b + c. Then, the coefficient of x^k is the sum over all (a,b,c) with a + b + c = k of that term. Therefore, the sum over all even k of that coefficient is [F(1) + F(-1)] / 2. So that seems correct.\n\nBut let me check with some small cases. For example, the sum when a + b + c = 0: only (0,0,0). The term is 1/(2^0 3^0 5^0) = 1. The sum for k=0 is 1.\n\nFor k=1: a + b + c = 1. There are 3 terms: (1,0,0), (0,1,0), (0,0,1). The sum is 1/(2^1) + 1/(3^1) + 1/(5^1) = 1/2 + 1/3 + 1/5 = (15 + 10 + 6)/30 = 31/30 ≈ 1.033...\n\nBut in our generating function F(1) is 15/4 = 3.75. Let me check F(1) is the sum over all k of the coefficients. Let me compute the sum:\n\nThe generating function F(1) is the product of the generating functions for a, b, c at x=1. Which is [sum_{a} 1/2^a] * [sum_b 1/3^b] * [sum_c 1/5^c].\n\nEach of these sums is a geometric series:\n\nsum_{a} (1/2)^a = 1/(1 - 1/2) = 2, sum_b (1/3)^b = 1/(1 - 1/3) = 3/2, sum_c (1/5)^c = 1/(1 - 1/5) = 5/4. Multiplying them gives 2 * 3/2 * 5/4 = 15/4, which is 3.75. So that seems correct.\n\nSimilarly, the total sum over all triples (a,b,c) is 15/4, and the sum over even k is 25/12 ≈ 2.083, and the sum over odd k is (F(1) - F(-1))/2 = (15/4 - 5/12)/2 = (45/12 - 5/12)/2 = (40/12)/2 = (10/3)/2 = 5/3 ≈ 1.666...\n\nSo total is 25/12 + 5/3 = 25/12 + 20/12 = 45/12 = 15/4, which matches F(1). So that seems correct.\n\nBut wait, 25/12 is approximately 2.083 and 5/3 ≈ 1.666, adding up to 3.75 which is 15/4. So that seems correct. Therefore, the answer is 25/12.\n\nWait, but the problem states that the answer is expressed as m/n with m and n coprime. 25 and 12 are coprime? 25 is 5², 12 is 2² * 3. No common factors. So m = 25, n = 12, so m + n = 37. Wait, but before I conclude, is this correct?\n\nWait, but let me think again. The problem is about non-negative integers a, b, c with a + b + c even. So according to the generating function approach, we have [F(1) + F(-1)] / 2 = 25/12. Is that the answer? But I need to check if there's a mistake in my logic.\n\nAlternatively, another approach. Let me think about splitting the variables into even and odd.\n\nBut since a, b, c are non-negative integers, and their sum is even. For each triple, the parity of a + b + c is determined by the sum of their individual parities.\n\nAlternatively, think of each variable contributing to the parity. So, the sum a + b + c is even if and only if there are 0 or 2 odd numbers among a, b, c. So maybe I can split the total sum into cases where the number of odd numbers is 0 or 2.\n\nBut that might be more complicated, but let's try.\n\nAlternatively, think of generating functions considering parity.\n\nLet me think about the generating function where each term is 1/(2^a 3^b 5^c), with a + b + c even.\n\nBut maybe another way: the generating function can be written as the product of generating functions for each variable, with some parity constraints. However, since the sum is even, maybe we can use the generating function for each variable with a variable that tracks parity.\n\nAlternatively, think of generating functions for a, b, c where each variable's generating function is modified to track whether it is even or odd.\n\nBut that might be more complicated. Alternatively, I can use the generating function that I already have, and check if 25/12 is correct.\n\nBut let me check with small cases.\n\nFor example, compute the sum over all triples with a + b + c even, and compute the sum manually for small a, b, c, and see if it's 25/12.\n\nWait, let's compute the sum for a + b + c = 0: 1 term, value 1.\n\na + b + c = 2: possible triples are:\n\n(0,0,2), (0,2,0), (2,0,0), (0,1,1), (1,0,1), (1,1,0). Let's compute each term:\n\n(0,0,2): 1/(2^0 3^0 5^2) = 1/25.\n\n(0,2,0): 1/(2^0 3^2 5^0) = 1/9.\n\n(2,0,0): 1/(2^2 3^0 5^0) = 1/4.\n\n(0,1,1): 1/(2^0 3^1 5^1) = 1/(3*5) = 1/15.\n\n(1,0,1): 1/(2^1 3^0 5^1) = 1/(2*5) = 1/10.\n\n(1,1,0): 1/(2^1 3^1 5^0) = 1/(2*3) = 1/6.\n\nAdding them up:\n\n1/25 + 1/9 + 1/4 + 1/15 + 1/10 + 1/6.\n\nLet me compute this:\n\nFirst, convert all to common denominator. Let's see, denominators are 25, 9, 4, 15, 10, 6. The least common multiple of these numbers. Let's see:\n\nFactors:\n\n25 = 5²\n\n9 = 3²\n\n4 = 2²\n\n15 = 3 * 5\n\n10 = 2 * 5\n\n6 = 2 * 3\n\nSo LCM is 2² * 3² * 5² = 4 * 9 * 25 = 900.\n\nConvert each term to denominator 900:\n\n1/25 = 36/900\n\n1/9 = 100/900\n\n1/4 = 225/900\n\n1/15 = 60/900\n\n1/10 = 90/900\n\n1/6 = 150/900\n\nAdding them up: 36 + 100 + 225 + 60 + 90 + 150 = Let's compute step by step:\n\n36 + 100 = 136\n\n136 + 225 = 361\n\n361 + 60 = 421\n\n421 + 90 = 511\n\n511 + 150 = 661\n\nSo total is 661/900 ≈ 0.7344...\n\nBut the total sum over all even k should include the k=0 term (1) and k=2 term (≈0.7344), and higher terms. But if the total sum is 25/12 ≈ 2.083..., then adding more terms would make it larger.\n\nBut maybe I can compute the total sum up to k=2 and see if it's consistent with the generating function approach.\n\nBut maybe this is too time-consuming. Alternatively, let me check the generating function approach again.\n\nWait, another way: the total sum over all triples is 15/4 = 3.75. The sum over even k is 25/12 ≈ 2.083, sum over odd k is 5/3 ≈ 1.666, which adds up to 3.75. So that seems correct.\n\nAlternatively, if I think about the parity: for each variable, the parity is independent? Wait, but the conditions on the sum. But since the sum's parity depends on the individual parities.\n\nAlternatively, think of the generating function as follows:\n\nThe generating function for each variable, considering parity:\n\nFor variable a: the generating function for even a: sum_{k even} (1/2^k) x^k, and for odd a: sum_{k odd} (1/2^k) x^k. Similarly for b and c. But then the total generating function would be the product of the generating functions for each variable, considering the parity. But since we want the total sum where a + b + c is even, it's equivalent to the product of the generating functions for each variable, multiplied by something?\n\nWait, perhaps not. Maybe another approach. Let me think.\n\nAlternatively, note that the parity of a + b + c is even if and only if an even number of the variables a, b, c are odd. So the total sum is equal to the sum over all triples where 0 or 2 of a, b, c are odd.\n\nBut this seems more complicated, but maybe we can use inclusion-exclusion.\n\nAlternatively, use the generating function approach where we consider the generating function for even and odd contributions.\n\nAlternatively, think of it as:\n\nLet me denote for each variable, the generating function for even and odd terms. So, for variable a, the generating function can be written as:\n\nsum_{a even} (1/2^a) x^a + sum_{a odd} (1/2^a) x^a = sum_{a} (1/2^a) x^a = 1/(1 - x/2). But we need to track parity.\n\nBut to get the total sum where a + b + c is even, we can use the following trick:\n\nLet me think of the generating function for each variable as follows:\n\nFor variable a, define two generating functions: E_a = sum_{a even} (1/2^a) and O_a = sum_{a odd} (1/2^a). Similarly for b and c. Then, the total generating function for even sums would be E_a * E_b * E_c + E_a * O_b * O_c + O_a * E_b * O_c + O_a * O_b * E_c.\n\nBecause we need an even number of odd terms. So, 0 odd terms: E_a E_b E_c. 2 odd terms: E_a O_b O_c, O_a E_b O_c, O_a O_b E_c. Therefore, the total is E_a E_b E_c + 3 * E_a O_b O_c.\n\nWait, but this might be easier to compute.\n\nFirst, compute E_a and O_a.\n\nFor variable a: sum_{a even} (1/2^a) = sum_{k=0}^infty (1/2^{2k}) = sum_{k=0}^infty (1/4)^k = 1 / (1 - 1/4) = 4/3.\n\nSimilarly, sum_{a odd} (1/2^a) = sum_{k=0}^\\infty (1/2^{2k + 1}) = (1/2) sum_{k=0}^infty (1/4)^k = (1/2) * (1 / (1 - 1/4)) = (1/2)*(4/3) = 2/3.\n\nSimilarly for variable b:\n\nE_b = sum_{b even} (1/3^b) = sum_{k=0}^\\infty (1/9)^k = 1 / (1 - 1/9) = 9/8.\n\nO_b = sum_{b odd} (1/3^b) = (1/3) * sum_{k=0}^\\infty (1/9)^k = (1/3) * (9/8) = 3/8.\n\nSimilarly for variable c:\n\nE_c = sum_{c even} (1/5^c) = 1 / (1 - 1/25) = 25/24.\n\nO_c = sum_{c odd} (1/5^c) = (1/5) * sum_{k=0}^\\infty (1/25)^k = (1/5) * (25/24) = 5/24.\n\nTherefore, the total sum is E_a E_b E_c + 3 E_a O_b O_c.\n\nCompute each term:\n\nFirst term: E_a E_b E_c = (4/3) * (9/8) * (25/24).\n\nLet me compute that:\n\nMultiply numerators: 4 * 9 * 25 = 4 * 225 = 900.\n\nMultiply denominators: 3 * 8 * 24 = 3 * 192 = 576.\n\nSo first term is 900 / 576.\n\nSimplify: divide numerator and denominator by 12: 75 / 48. Divide by 3: 25 / 16.\n\nWait:\n\nWait 900 / 576: Divide numerator and denominator by 12: 75 / 48. Then divide by 3: 25 / 16. Yes, 25/16.\n\nSecond term: 3 * E_a * O_b * O_c.\n\nCompute E_a * O_b * O_c = (4/3) * (3/8) * (5/24).\n\nMultiply numerators: 4 * 3 * 5 = 60.\n\nMultiply denominators: 3 * 8 * 24 = 576.\n\nSo 60 / 576. Simplify: divide numerator and denominator by 12: 5 / 48.\n\nMultiply by 3: 15 / 48 = 5 / 16.\n\nTherefore, total sum is 25/16 + 5/16 = 30/16 = 15/8.\n\nWait, 15/8 is 1.875. But previously we had 25/12 ≈ 2.083. These are conflicting results. Therefore, one of the approaches is wrong.\n\nThis is concerning. So now I have two different results: 25/12 and 15/8. Which one is correct?\n\nWait, so I need to check where the mistake is.\n\nFirst approach: using F(x) = [1/(1 - x/2)][1/(1 - x/3)][1/(1 - x/5)], then [F(1) + F(-1)] / 2 = 25/12 ≈ 2.083.\n\nSecond approach: considering E_a E_b E_c + 3 E_a O_b O_c = 15/8 ≈ 1.875.\n\nThese are different results, so I must have made an error in one of the methods.\n\nLet me check the second approach again.\n\nIn the second approach, the reasoning was that the total sum over even a + b + c is equal to the sum over triples where 0 or 2 variables are odd. But maybe that's not correct?\n\nWait, no. Wait, if we want a + b + c even, then the number of odd numbers among a, b, c must be even (0 or 2). Wait, but if all three are even, that's 0 odd numbers, which is even. If two are odd and one is even, that's 2 odd numbers, which is even. If all three are odd, then 3 odd numbers, which is odd. So the total number of triples with a + b + c even is the number of triples with 0 odd numbers or 2 odd numbers. Therefore, the total generating function is:\n\n(E_a E_b E_c) + (E_a O_b O_c + E_a O_b O_c? Wait, no.\n\nWait, the number of ways to have 0 odd numbers: all even, so E_a E_b E_c.\n\nNumber of ways to have 2 odd numbers: there are C(3,2) = 3 ways: (odd, odd, even), (odd, even, odd), (even, odd, odd). So each term is E_a O_b O_c, E_a O_b O_c, E_a O_b O_c? Wait no, each term is different.\n\nWait, no, if we have two odd variables and one even variable. For example, if variable a is odd, variable b is odd, variable c is even: that's O_a O_b E_c. Similarly for O_a E_b O_c and E_a O_b O_c. Therefore, the total is E_a O_b O_c + O_a E_b O_c + O_a O_b E_c. So the total is 3 * E_a O_b O_c? No, because E_a O_b O_c is not the same as O_a E_b O_c, etc. Wait, no. Wait, E_a is sum over even a, O_a is sum over odd a, same for others. Therefore, each term is E_a O_b O_c, O_a E_b O_c, O_a O_b E_c. Therefore, sum is E_a O_b O_c + O_a E_b O_c + O_a O_b E_c.\n\nTherefore, the total is E_a O_b O_c + O_a E_b O_c + O_a O_b E_c = E_a O_b O_c * (1 + (O_a / E_a) + (O_b / E_b) + ...? Wait, no, better compute it as:\n\nBut E_a O_b O_c + O_a E_b O_c + O_a O_b E_c = (E_a O_b O_c + O_a E_b O_c + O_a O_b E_c). Since each term has two odd variables and one even variable, the total is three times E_a O_b O_c? No, because E_a is not the same as O_a. Wait, for example, E_a O_b O_c is different from O_a E_b O_c, unless E_a = O_a, which they are not. Therefore, the total is not 3 * E_a O_b O_c. Instead, each term is a different product. Therefore, in my previous calculation, I assumed that the total is E_a E_b E_c + 3 E_a O_b O_c, but that is incorrect. Instead, the second term is E_a O_b O_c + O_a E_b O_c + O_a O_b E_c.\n\nTherefore, my mistake was in the second approach where I thought it was 3 * E_a O_b O_c. But actually, each term is different. Therefore, need to compute all three terms.\n\nTherefore, let me recalculate the second approach with that correction.\n\nSo total sum = E_a E_b E_c + E_a O_b O_c + O_a E_b O_c + O_a O_b E_c.\n\nSo compute each term.\n\nFirst term: E_a E_b E_c = (4/3)(9/8)(25/24) = 25/16 as before.\n\nSecond term: E_a O_b O_c = (4/3)(3/8)(5/24) = (4*3*5)/(3*8*24) = (60)/(576) = 5/48.\n\nThird term: O_a E_b O_c = (2/3)(9/8)(5/24). Compute that: (2*9*5)/(3*8*24) = (90)/(576) = 15/96 = 5/32.\n\nWait, let me compute again:\n\nO_a = 2/3, E_b = 9/8, O_c = 5/24.\n\nMultiply them: (2/3)*(9/8)*(5/24) = (2*9*5)/(3*8*24) = (90)/(576). Simplify: divide numerator and denominator by 18: 5/32. Yes.\n\nFourth term: O_a O_b E_c = (2/3)*(3/8)*(25/24).\n\nCompute: (2/3)*(3/8)*(25/24) = (2*3*25)/(3*8*24) = (150)/(576) = 25/96.\n\nTherefore, total sum is:\n\nFirst term: 25/16 + second term: 5/48 + third term: 5/32 + fourth term: 25/96.\n\nConvert all to denominator 96.\n\n25/16 = (25 * 6)/96 = 150/96.\n\n5/48 = 10/96.\n\n5/32 = 15/96.\n\n25/96 = 25/96.\n\nSo total is 150 + 10 + 15 + 25 = 200 over 96.\n\nSimplify 200/96: divide numerator and denominator by 8: 25/12.\n\nWhich is the same as the first approach! 25/12. So that's correct. My mistake was in the second approach when I assumed that it was 3 * E_a O_b O_c instead of the sum of three different terms. So that's fixed now, and we get 25/12. Therefore, both methods agree. Therefore, the correct answer is 25/12.\n\nTherefore, m + n is 25 + 12 = 37. So the answer is 37.\n\nBut just to be thorough, let me check with another approach.\n\nAlternative approach: Let me consider that the total sum over all a, b, c is 15/4. The sum over even a + b + c is 25/12, and the sum over odd is 5/3. Let me check that 25/12 + 5/3 is 25/12 + 20/12 = 45/12 = 15/4, which matches. So that seems correct.\n\nAlternatively, maybe think of variables as follows: For each variable, the probability that it is even or odd, but in terms of generating functions. But I think the previous methods are correct.\n\nTherefore, the answer is 25/12, so m + n = 25 + 12 = 37.\n\n**Final Answer**\n\\boxed{37}\nTime is up. I should stop thinking and now write a summary containing all key steps required to solve the problem.</think>"
    input_tokenized = tokenizer(sentence, return_tensors="pt").to(model.device)

    attn_store = {}

    def make_hook(layer_id):
        def hook(module, input, output):
            # output is (hidden_states, attn_weights) in Qwen3's self_attn
            attn_weights = output[1]  # shape: [batch, heads, seq_len, seq_len]
            # breakpoint()
            attn_store[layer_id] = attn_weights.mean(dim=1).detach().cpu()
        return hook

    # Register hook only for the target layer
    target_layers = [i for i in range(model.config.num_hidden_layers)]
    handles = [model.layers[i].self_attn.register_forward_hook(make_hook(i)) for i in target_layers]

    with torch.no_grad():
        _ = model(**input_tokenized)  # no output_attentions=True

    for h in handles:
        h.remove()
    
    breakpoint()
    

    # Run the eviction algorithm to get reasoning steps to evict and new reasoning chain
    evicted_steps, new_reasoning_chain = run_eviction_algorithm(
        attn_store, 
        tokenizer, 
        input_tokenized, 
        target_reduction=0.25
    )
    
    print(f"\nEvicted reasoning steps: {evicted_steps}")
    print(f"\nNew reasoning chain:")
    print(new_reasoning_chain)
    
    return evicted_steps, new_reasoning_chain

if __name__ == "__main__":
    test_with_example() 