#!/bin/bash

JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs/vit_tiny_patch16_224"

# Define the base multipliers
# N_VALUES=(2 15 37 80 99 130 144 153 162 176 250 319 409 277 417 466 486 698 770 879 968 207 327 340 353 387 468 505)
N_VALUES=(551 917 729 746 812 10 17 19 614)

# Create an array of indices
SAMPLE_INDICES=()
for n in "${N_VALUES[@]}"; do
    start=$((n * 50))
    end=$(((n+1) * 50))
    for ((i=start; i<end; i++)); do
        SAMPLE_INDICES+=($i)
    done
done


# Loop over sample indices
for sample_idx in "${SAMPLE_INDICES[@]}"; do
    sample_dir="$JOBS_DIR/sample_${sample_idx}*"
    # If there are multiple matches, pick the first one
    sample_dir=$(ls -d $sample_dir 2>/dev/null | head -n 1)
    result_file="$sample_dir/results/R$(printf "%04d" $sample_idx)/C$(printf "%06d" $sample_idx).json"
    if [ -f "$result_file" ]; then
        echo "Skipping sample_idx $sample_idx (result file exists)"
        continue
    fi
    echo "Running with sample index $sample_idx"

    python main.py \
        --save_root "jobs/sample_${sample_idx}" \
        --num_noise_sample 100 \
        --model "vit_tiny_patch16_224" \
        --gpu 4 \
        --noise_type "other" \
        --debug_index 0 \
        --detailed_save \
        --slightly_quiet_mode \
        --efficient_mode \
        --target_sample_idx $sample_idx
done

