#!/bin/bash


# Define the base multipliers
N_VALUES=(2 15 37 80 99 130 144 153 162 176 250 319 409 277 417 466 486 698 770 879 968)
N_VALUES_2=(207 327 340 353 387 468 505 530 587 629 717 779 805 947 950)

# Create an array of indices
SAMPLE_INDICES=()
for n in "${N_VALUES[@]}"; do
    start=$((n * 50))
    end=$(((n+1) * 50))
    for ((i=start; i<end; i++)); do
        SAMPLE_INDICES+=($i)
    done
done

# Loop over sample indices
for sample_idx in "${SAMPLE_INDICES[@]}"; do
    echo "Running with sample index $sample_idx"

    python main.py \
        --save_root "jobs/sample_${sample_idx}" \
        --num_noise_sample 100 \
        --model "vit_small_patch16_224" \
        --gpu 0 \
        --noise_type "other" \
        --debug_index 0 \
        --detailed_save \
        --slightly_quiet_mode \
        --efficient_mode \
        --target_sample_idx $sample_idx
done

