#!/bin/bash

# Original N values to exclude
EXCLUDE_N=(2 15 37 80 99 130 144 153 162 176 250 277 319 409 417 466 486 698 770 879 968)

# Set the full path to jobs directory
JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs"

# Generate 50 random N values (excluding the ones in EXCLUDE_N)
SAMPLE_N=($(
    shuf -i 0-999 -n 200 | while read n; do
        for excluded in "${EXCLUDE_N[@]}"; do
            if [ "$n" -eq "$excluded" ]; then
                continue 2
            fi
        done
        echo $n
    done | shuf -n 50 | sort -n
))

# Loop over the N values and process all indices in each range
for n in "${SAMPLE_N[@]}"; do
    start=$((n * 50))
    end=$(((n + 1) * 50))
    
    for ((i=start; i<end; i++)); do
        # Check if a file with matching index exists in jobs directory
        if [ -d "$JOBS_DIR" ] && ls "$JOBS_DIR/" | grep -q "^sample_${i}_"; then
            echo "Skipping index $i as matching file already exists"
            continue
        fi
        echo "Running with sample index $i"
        python main.py \
            --save_root "jobs/sample_${i}" \
            --num_noise_sample 100 \
            --model "vit_tiny_patch16_224" \
            --gpu 1 \
            --noise_type "other" \
            --debug_index 0 \
            --detailed_save \
            --slightly_quiet_mode \
            --efficient_mode \
            --target_sample_idx $i
    done
done 