## Code Release 

Here is a code release for the 2025 NeurIPS submission "Causal Path Tracing in Transformers". This code will be released via a GitHub repo (in a more polished form) if accepted.


## Prerequisites
### Recommended Environment
* OS : Ubuntu 20.04
* CUDA : 11.8
* Pytorch 2.1.0 
Required packages are listed in **CausalPathTracing/CPT/conda.yaml**. You can install by running:

```
conda env create -f conda.yaml
conda activate llm_tracing
```

## Path Tracing Implementation

### Our Method: Causal Path Tracing (CPT)
- **Directory**: `CausalPathTracing/CPT`
- **How to Run**:  
  Use one of the `run_*.sh` scripts to run experiments.  
  Example:
  ```bash
  bash CausalPathTracing/CPT/language/run_gptxs.sh
- **Core File (Main Algorithm)**:
  ```bash
  main.py and lib/search_func.py

### Other Baselines
- **Directory**: `CausalPathTracing/for_baseline`
- **Reference**: `https://github.com/kmeng01/rome` and `https://github.com/Aaquib111/edge-attribution-patching`

### Self-repair Experiments
- **File**: `CausalPathTracing/self_repair/backup_research/for_experiment/GOOD_breakdown_self_repair.py`
- **Reference**: `https://github.com/starship006/backup_research`

### For Experimental Results (Traced Paths)
- **File**: `(attached) traced_path_data.tar.gz`
