import argparse

def arg_func():

        
    parser = argparse.ArgumentParser()
    parser.add_argument('--gpu', default="6", type=str, help='gpu')
    parser.add_argument('--end_symbol', default=[".", "?"])
    parser.add_argument('--save_root', default="jobs/debug", type=str)
    parser.add_argument('--load_path_saver', default=None, type=str) # folder

    parser.add_argument('--num_noise_sample', default=10, type=int)
    parser.add_argument('--model', default="gpt-xl", type=str)
    parser.add_argument('--noise_type', default="other", required=True, choices=['other', 'emb_added', 'zero','mean'], help="noise type")
    parser.add_argument('--dataset_type', default="rome_factual_1000", choices=['rome_factual_1000', 'sst2', 'lama_trex'], help="dataset_type")

    parser.add_argument('--debug_index', default=None, type=int)
    parser.add_argument('--subset_search', default="minimality", type=str)
    parser.add_argument('--efficient_mode', help='not check counterfactual', action='store_true')
    parser.add_argument('--slightly_quiet_mode', help='slightly_quiet_mode', action='store_true')
    parser.add_argument('--debug_min_search', help='debug_min_search', action='store_true')
    parser.add_argument('--reverse', help='debug_min_search', action='store_true')
    parser.add_argument('--model_save', default=None, type=str)
    
    parser.add_argument('--detailed_save', help='detailed_save', action='store_true')
    parser.add_argument('--except_stopword', help='except_stopword', action='store_true')
    parser.add_argument('--correct_check_first', help='correct_check_first', action='store_true')
    
    parser.add_argument('--target_sample_index', default=None, type=str)
    parser.add_argument('--target_sample_index_list', default=None, type=str)
    
    
    args = parser.parse_args()

    args.out_num = 1

    if args.model == "gpt2-mini":
        args.model = "erwanf/gpt2-mini"
    elif args.model == "gpt2-xs":
        args.model = "AlgorithmicResearchGroup/gpt2-xs"
    elif args.model == "pythia-14m":
        args.model = "EleutherAI/pythia-14m"
    elif args.model == "pythia-1b":
        args.model = "EleutherAI/pythia-1b"
        

    return args

