import os 
import shutil 
import tqdm

target = 'jobs_arxiv_for_test/250512_collection/vit_tiny_patch16_224'
dst = 'jobs_arxiv_for_test/250512_collection/vit_tiny_patch16_224_converted'

os.makedirs(dst, exist_ok=True)
dst_results_path = os.path.join(dst, "results")
os.makedirs(dst_results_path, exist_ok=True)

dst_inp_info_path = os.path.join(dst, "inp_info")
os.makedirs(dst_inp_info_path, exist_ok=True)

target_folder = sorted([i for i in os.listdir(target) if ("sample_" in i)])

real_target_folder = []
for tar in target_folder:
    idx = int(tar.split("_")[1])
    if os.path.isfile(os.path.join(target, tar, "results", "R{:04d}".format(idx), "C{:06d}.json".format(idx))):
        real_target_folder.append(tar)
        
for tar in tqdm.tqdm(real_target_folder):
    idx = int(tar.split("_")[1])
    shutil.copytree(os.path.join(target, tar, "results","R{:04d}".format(idx)), os.path.join(dst_results_path,"R{:04d}".format(idx)))
    shutil.copy(os.path.join(target, tar, "inp_info", "I{:06d}.txt".format(idx)), dst_inp_info_path)
        