import argparse

def arg_func():

        
    parser = argparse.ArgumentParser()
    parser.add_argument('--gpu', default="6", type=str, help='gpu')
    parser.add_argument('--end_symbol', default=[".", "?"])
    parser.add_argument('--save_root', default="jobs/debug", type=str)
    parser.add_argument('--load_path_saver', default=None, type=str) # folder

    parser.add_argument('--num_noise_sample', default=10, type=int)
    parser.add_argument('--model', default="gpt-xl", type=str)
    parser.add_argument('--dataset', default="imagenet", type=str)
    parser.add_argument('--noise_type', default="other", required=True, choices=['other', 'emb_added', 'zero','mean'], help="noise type")

    parser.add_argument('--debug_index', default=None, type=int)
    parser.add_argument('--subset_search', default="minimality", type=str)
    parser.add_argument('--efficient_mode', help='not check counterfactual', action='store_true')
    parser.add_argument('--detailed_save', help='detailed_save', action='store_true')
    parser.add_argument('--slightly_quiet_mode', help='slightly_quiet_mode', action='store_true')
    parser.add_argument('--debug_min_search', help='debug_min_search', action='store_true')
    parser.add_argument('--debug_min_search_start_block', default=8, type=int)
    
    parser.add_argument('--target_sample_idx', default=None, type=int)
    parser.add_argument('--evaluation_mode', help='evaluation_mode', action='store_true')
    args = parser.parse_args()

    args.out_num = 1

    if args.model == "gpt2-mini":
        args.model = "erwanf/gpt2-mini"

    return args

