#!/bin/bash

JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs/vit_tiny_patch16_224"
# JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs/deit_tiny_patch16_224"
N_VALUES=(2 15 37 80 99 130 144 153 162 176 250 319 409 277 417 466 486 698 770 879 968 207 327 340 353 387 468 505 530 587 629 717 779 805 947 950)

total_count=0
for n in "${N_VALUES[@]}"; do
    start=$((n * 50))
    end=$(((n + 1) * 50))
    count=0
    for ((i = start; i < end; i++)); do
        # Find all matching sample directories and pick the one with the largest time suffix
        sample_dirs=( $JOBS_DIR/sample_${i}_* )
        sample_dir=""
        if [ ${#sample_dirs[@]} -gt 0 ]; then
            sample_dir=$(printf "%s\n" "${sample_dirs[@]}" | awk -F'_' '{print $NF, $0}' | sort -n | tail -1 | cut -d' ' -f2-)
        fi
        if [ -n "$sample_dir" ]; then
            result_file="$sample_dir/results/R$(printf "%04d" $i)/C$(printf "%06d" $i).json"
            if [ -f "$result_file" ]; then
                count=$((count + 1))
            fi
        fi
    done
    total_count=$((total_count + count))
    echo "Label $n: $count result files (out of 50)"
done
echo "Total result files: $total_count"