#!/bin/bash

JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs/vit_tiny_patch16_224"
# JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs/deit_tiny_patch16_224"
N_VALUES=(2 15 37 80 99 130 144 153 162 176 250 319 409 277 417 466 486 698 770 879 968 207 327 340 353 387 468 505 530 587 629 717 779 805 947 950)

for n in "${N_VALUES[@]}"; do
    start=$((n * 50))
    end=$(((n + 1) * 50))
    for ((i = start; i < end; i++)); do
        sample_dirs=( $JOBS_DIR/sample_${i}_* )
        sample_dir=""
        if [ ${#sample_dirs[@]} -gt 0 ]; then
            # Find the latest (largest time) sample_dir
            sample_dir=$(printf "%s\n" "${sample_dirs[@]}" | awk -F'_' '{print $NF, $0}' | sort -n | tail -1 | cut -d' ' -f2-)
            # Remove all but the latest sample_dir
            for dir in "${sample_dirs[@]}"; do
                if [ "$dir" != "$sample_dir" ]; then
                    rm -rf "$dir"
                fi
            done
        fi
    done
done