#!/bin/bash

# JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs_oh/vit_tiny_patch16_224"
JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs/deit_tiny_patch16_224"

while read -r i; do
    sample_dirs=( $JOBS_DIR/sample_${i}_* )
    sample_dir=""
    if [ ${#sample_dirs[@]} -gt 0 ]; then
        # Find the latest (largest time) sample_dir
        sample_dir=$(printf "%s\n" "${sample_dirs[@]}" | awk -F'_' '{print $NF, $0}' | sort -n | tail -1 | cut -d' ' -f2-)
        # Remove all but the latest sample_dir
        for dir in "${sample_dirs[@]}"; do
            if [ "$dir" != "$sample_dir" ]; then
                rm -rf "$dir"
            fi
        done
    fi
done < /data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/indices_part1.txt