#!/bin/bash

# Set the full path to jobs directory
JOBS_DIR="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/jobs_oh/deit_tiny_patch16_224"
INDICES_FILE="/data5/users/anonymoususer/causal_path/CausalPathTracing_for_ViT/main/indices_part1.txt"

# Read indices from the file into an array
mapfile -t SAMPLE_INDICES < "$INDICES_FILE"

# Loop over the indices and process each one
for i in "${SAMPLE_INDICES[@]}"; do
    # Check if a file with matching index exists in jobs directory
    if [ -d "$JOBS_DIR" ] && ls "$JOBS_DIR/sample_${i}"* 1> /dev/null 2>&1; then
        echo "Skipping index $i as matching file already exists"
        continue
    fi
    echo "Running with sample index $i"
    python main.py \
        --save_root "jobs_oh/sample_${i}" \
        --num_noise_sample 100 \
        --model "deit_tiny_patch16_224" \
        --dataset "officehome" \
        --gpu 2 \
        --noise_type "other" \
        --debug_index 0 \
        --detailed_save \
        --slightly_quiet_mode \
        --efficient_mode \
        --target_sample_idx $i
done 