#! /bin/bash


echo Processing text
for model_name in AlgorithmicResearchGroup/gpt2-xs EleutherAI/pythia-14m EleutherAI/pythia-1b; do
    for fact_file in knowns1000 lama; do 
        echo python experiments/causal_trace.py --model_name $model_name --fact_file $fact_file --token_range corrupt_all --except_stopword
        python experiments/causal_trace.py --model_name $model_name --fact_file $fact_file --token_range corrupt_all --except_stopword
    done
done

echo Processing image
for model_name in vit_tiny_patch16_224 deit_tiny_patch16_224; do
    for data_name in imagenet officehome; do
        echo python experiments/causal_trace.py --token_range "image" --image_dataset $data_name --model_name $model_name
        python experiments/causal_trace.py --token_range "image" --image_dataset $data_name --model_name $model_name
    done
done
