
"""Core TensorFlow types."""

import dataclasses
from typing import Any, Callable, Mapping, Sequence, Optional, Union, NamedTuple

import numpy as np
import tensorflow as tf
from tensorflow import Tensor


class PandasDataFrame(object):
    """Symbolic pandas frame
    Pandas type are too loose you get an Any. We want a DataFrame
    """
    pass


class BoolTensor(Tensor):
    """Bool tensor """


class FloatTensor(Tensor):
    """Float tensor """


class IntTensor(Tensor):
    """Integer tensor"""


class Symbol(Tensor):
    """Symbolic "graph" Tensor.

    These objects represent the output of an op definition and do not carry a
    value.
    """
    pass


class Value(Tensor):
    """Tensor that can be associated with a value (aka "eager tensor").

    These objects represent the (usually future) output of executing an op
    immediately.
    """

    def numpy(self):
        pass


EqFunc = Callable[[Any, Any], bool]


def _optional_eq(a: Any, b: Any, eq_fun: EqFunc) -> bool:
    """__eq__ for Optional[Any] types."""
    if a is None:
        return b is None
    elif b is None:
        return False

    return eq_fun(a, b)


def _basic_eq(a: Any, b: Any) -> bool:
    eq: bool = a == b
    return eq


def _ndarray_eq(a: np.ndarray, b: np.ndarray) -> bool:
    eq: bool = np.allclose(a, b, rtol=0, atol=0, equal_nan=True)
    return eq


def _tf_eq(a: Tensor, b: Tensor) -> bool:
    eq: bool = tf.math.reduce_all(tf.math.equal(a, b))
    return eq
