import difflib
from termcolor import colored
import re
import numpy as np


def diff_strings(a, b, max_len=64, miss_char="_", spacers=True):
    a = a.decode("utf-8") if isinstance(a, bytes) else a
    b = b.decode("utf-8") if isinstance(b, bytes) else b
    
    a = a.replace('\n', ' ').replace('\t', '').replace('  ', ' ')
    b = b.replace('\n', ' ').replace('\t', '').replace('  ', ' ')
    # b = bytes(b).decode("utf-8") 
    a = a[:max_len]
    b = b[:max_len]
    # output = []
    s1 = []
    s2 = []
    substrings = []
    spacers = []
    matcher = difflib.SequenceMatcher(None, a, b)
    for opcode, a0, a1, b0, b1 in matcher.get_opcodes():
        a_len = a1 - a0
        b_len = b1 - b0

        if opcode == "equal":
            # output.append(a[a0:a1])
            s1.append(a[a0:a1])
            s2.append(a[a0:a1])
            substrings.append(a[a0:a1])
            spacers.append("|" * a_len)
        elif opcode == "insert":
            s1.append(" " * b_len)
            s2.append(colored(b[b0:b1], "green"))
            spacers.append(" " * b_len)
        elif opcode == "delete":
            s1.append(colored(a[a0:a1], "yellow"))
            s2.append(" " * a_len)
            spacers.append(' ' * a_len)
        elif opcode == "replace":
            s1.append(colored(a[a0:a1], "blue"))
            s2.append(colored(b[b0:b1], "blue"))

            if a_len > b_len:
                spacers.append(' ' * a_len)
                s2.append(miss_char *  (a_len-b_len))
            elif b_len > a_len:
                spacers.append(' ' * b_len)
                s1.append(miss_char *  (b_len-a_len))

    # fimxe: cleanup
    substring_len = [len(s) for s in substrings]
    sorted_substr = np.take(substrings, np.argsort(substring_len))

    # FIXME return this as dictionary to unify display in display_match
    # FIXME:L find misalignement bug
    s1 = "".join(s1)
    s2 = "".join(s2)
    spacers = "".join(spacers)
    spacers = spacers.replace(' | ', '  ')
    print(f"{s1}")
    
    if spacers:
        print(f"{spacers}")

    print(f"{s2}")
    print("")


def colorize_substring(text, match_text, match, color):
    
    ctext = text[:match.a] + colored(text[match.a: match.a + match.size], color) + text[match.a + match.size:] + colored("", 'white')
    cmatch_text = match_text[:match.b] + colored(match_text[match.b: match.b + match.size], color) + match_text[match.b + match.size:]  + colored("", 'white')

    return ctext, cmatch_text
    

def display_match(match, max_len=64, miss_char=" ", spacers=True):
    
    text = match['text']
    match_text = match['match_text']
    
    text = text.decode("utf-8") if isinstance(text, bytes) else text
    match_text = match_text.decode("utf-8") if isinstance(match_text, bytes) else match_text
    
    text = text.replace('\n', ' ').replace('\t', '').replace('  ', ' ')
    match_text = match_text.replace('\n', ' ').replace('\t', '').replace('  ', ' ')

    # FIXME before or after?
    text = text[:max_len]
    match_text = match_text[:max_len]

    #FIXME bug and put in a function - allows for n matches and use different colors, green, yellow, red, magenta
    # for all n char (5)
    seqmatch = difflib.SequenceMatcher(None, text, match_text)
    #print(loc, loc.a, loc.size)
    loc = seqmatch.find_longest_match(0, len(text), 0, len(match_text))
    max_sub = text[loc.a: loc.a + loc.size]
    
    colors = ['blue', 'yellow', 'green', 'magenta', 'cyan', 'red']
    for idx, match in enumerate(seqmatch.get_matching_blocks()):
        if idx == len(colors):
            break
        loc = seqmatch.find_longest_match(0, len(text), 0, len(match_text))

        text, match_text = colorize_substring(text, match_text, match, colors[idx])
        
    

    ctext = text[:loc.a] + colored(text[loc.a: loc.a + loc.size], 'green') + text[loc.a + loc.size:] + colored("", 'white')
    cmatch_text = match_text[:loc.b] + colored(match_text[loc.b: loc.b + loc.size], 'green') + match_text[loc.b + loc.size:]  + colored("", 'white')

    print("")
    print("text\t:", ctext)
    print("match\t:", cmatch_text)
  

    print("")
    print(f"📏distance:\t{match['distance']}")    
    label = match['label']
    match_label = match['match_label']
    symb = "✅" if label == match_label else "❌"
    print(f"{symb} labels:\t{match['label']} / {match['match_label']}")
    
    # FIXME green
    print("")
    diff_strings(text, match_text, miss_char=miss_char, spacers=spacers)
    print("----------------------------------------------------")
    print("")
