from datasets.dataset_loader import DatasetLoader
from models.fused_ann import FusedANN
from models.range_ann import RangeANN


def query_single_filter(fused_ann, query_vector, query_attribute, top_k=10):
    return FusedANN.query_single(query_vector, query_attribute, top_k)

def query_multi_filter(fused_ann, query_vector, attributes_list, alpha_list, beta_list, top_k=10):
    return FusedANN.query_multi(query_vector, attributes_list, alpha_list, beta_list, top_k)

def query_range_filter(range_ann, query_vector, attr_low, attr_high, radius, top_k=10):
    return RangeANN.query_range(query_vector, attr_low, attr_high, radius, top_k)