import numpy as np
import time
from models.fused_ann import FusedANN
from models.base_ann import BaseANN

def run_scalability_experiment():
    sizes = [10000, 100000, 500000, 1000000]
    d = 128
    m = 32
    times = []
    for size in sizes:
        vectors = np.random.rand(size, d)
        attributes = np.random.rand(size, m)

        ann_algorithm = SimpleANN()
        fused_ann = FusedANN(ann_algorithm)
        start = time.time()
        fused_ann.build_single(vectors, attributes)
        elapsed = time.time() - start
        times.append(elapsed)
        print(f"Scalability - Dataset size {size}: Index Building Time: {elapsed:.2f}s")

if __name__ == "__main__":
    run_scalability_experiment()