import numpy as np
from api.build_index import build_fused_index, build_range_index
from api.query_index import query_single_filter, query_range_filter
from models.base_ann import BaseANN

class SimpleANN(BaseANN):
    def __init__(self):
        self.vectors = None

    def build_index(self, vectors):
        self.vectors = vectors

    def query(self, vector, top_k):
        dists = np.linalg.norm(self.vectors - vector, axis=1)
        return np.argsort(dists)[:top_k]

    def get_vector(self, idx):
        return self.vectors[idx]

def main():
    ann_algorithm = SimpleANN()

    # Single Attribute Example
    fused_ann = build_fused_index("my_dataset", ann_algorithm)
    q_vec, q_attr = np.random.rand(128), np.random.rand(32)
    results = query_single_filter(fused_ann, q_vec, q_attr, top_k=5)
    print("Single Attribute Results:", results)

    # Range query example
    range_ann = build_range_index("my_dataset", ann_algorithm)
    attr_low, attr_high = np.random.rand(32), np.random.rand(32)
    radius = 0.2
    range_results = query_range_filter(range_ann, q_vec, attr_low, attr_high, radius, top_k=5)
    print("Range Query Results:", range_results)

if __name__ == "__main__":
    main()