import numpy as np

class Transformer:
    @staticmethod
    def single_transform(vectors, attributes, alpha, beta):
        blocks = vectors.shape[1] // attributes.shape[1]
        transformed = np.zeros_like(vectors)
        for b in range(blocks):
            transformed[:, b*attributes.shape[1]:(b+1)*attributes.shape[1]] = \
                (vectors[:, b*attributes.shape[1]:(b+1)*attributes.shape[1]] - alpha * attributes) / beta
        return transformed

    @staticmethod
    def multi_transform(vectors, attributes_list, alpha_list, beta_list):
        for attr, alpha, beta in zip(attributes_list, alpha_list, beta_list):
            vectors = Transformer.single_transform(vectors, attr, alpha, beta)
        return vectors