#!/bin/bash


for size in 128 512 1024 2048
do
    for seed in 45 87 62 31 54
    do
        python cli.py -d QM7 --min_node 4 --max_node 20 -m SAGE -l $size $size -p mean --n_epochs 500 -wb 1 -seed $seed
        python cli.py -d QM7 --min_node 4 --max_node 20 -m GCN -l $size $size --n_epochs 500 -wb 1 -seed $seed
        python cli.py -d QM7 --min_node 4 --max_node 20 -m GAT -l $size $size -p 1 --n_epochs 500 -wb 1 -seed $seed

    done
done

for size in 128 512 1024 2048
do
    for seed in 45 87 62 31 54
    do
        python cli.py -d Letter-med --min_node 4 --max_node 20 -m SAGE -l $size $size -p mean --n_epochs 500 -wb 1 -seed $seed
        python cli.py -d Letter-med --min_node 4 --max_node 20 -m GCN -l $size $size --n_epochs 500 -wb 1 -seed $seed
        python cli.py -d Letter-med --min_node 4 --max_node 20 -m GAT -l $size $size -p 1 --n_epochs 500 -wb 1 -seed $seed

    done
done

for size in 128 512 1024 2048
do
    for seed in 45 87 62 31 54
    do
        python cli.py -d DBLP_v1 --min_node 4 --max_node 20 -m SAGE -l $size $size -p mean --n_epochs 500 -wb 1 -seed $seed
        python cli.py -d DBLP_v1 --min_node 4 --max_node 20 -m GCN -l $size $size --n_epochs 500 -wb 1 -seed $seed
        python cli.py -d DBLP_v1 --min_node 4 --max_node 20 -m GAT -l $size $size -p 1 --n_epochs 500 -wb 1 -seed $seed

    done
done

for size in 128 512 1024 2048
do
    for seed in 45 87 62 31 54
    do
        python cli.py -d QM7 --min_node 4 --max_node 20 -m QGNN -p $size 2 1 4 --n_epochs 500 -wb 1 -seed $seed  -q 10
        python cli.py -d DBLP_v1 --min_node 4 --max_node 20 -m QGNN -p $size 2 1 4 --n_epochs 500 -wb 1 -seed $seed  -q 10
        python cli.py -d Letter-med --min_node 4 --max_node 20 -m QGNN -p $size 2 1 4 --n_epochs 500 -wb 1 -seed $seed  -q 10


    done
done

for size in 128 512 1024 2048
do
    python cli.py -d QM9 --min_node 4 --max_node 20 -m SAGE -l $size $size -p mean --n_epochs 500 -wb 1
    python cli.py -d QM9 --min_node 4 --max_node 20 -m GCN -l $size $size --n_epochs 500 -wb 1
    python cli.py -d QM9 --min_node 4 --max_node 20 -m GAT -l $size $size -p 1 --n_epochs 500 -wb 1
    python cli.py -d QM9 --min_node 4 --max_node 20 -m QGNN -p $size 2 1 4 --n_epochs 500 -wb 1 -seed $seed  -q 10 --n_processes 4
done

for size in 128 512 1024 2048
do
    python cli.py -d CoverGen --min_node 4 --max_node 21 -m QGNN -p $size 2 1 4 --n_epochs 500 -wb 1 -q 10

done

python generate_random_matrices.py -d QM7 --min_node 4 --max_node 20 --n_processes 4 -seed 45
python generate_random_matrices.py -d DBLP_v1 --min_node 4 --max_node 20 --n_processes 4 -seed 45
python generate_random_matrices.py -d Letter-med --min_node 4 --max_node 20 --n_processes 4 -seed 45
python generate_random_matrices.py -d QM9 --min_node 4 --max_node 20 --n_processes 4

for size in 32 64 128
do
    python train_random_matrices.py -d QM7 --min_node 4 --max_node 20 -seed 45 -p $size 8 8 4
    python train_random_matrices.py -d DBLP_v1 --min_node 4 --max_node 20 -seed 45 -p $size 8 8 4
    python train_random_matrices.py -d Letter-med --min_node 4 --max_node 20 -seed 45 -p $size 8 8 4
    python train_random_matrices.py -d QM9 --min_node 4 --max_node 20 -seed 45 -p $size 8 8 4

done



