from dataset_loader.DBLP_v1 import DBLP_v1
from dataset_loader.Letter import Letter
from dataset_loader.QM7Dataset import QM7Dataset
from dataset_loader.QM9 import QM9Dataset
from dataset_loader.GraphCovers import GraphCovers
from dataset_loader.Zinc import ZincDataset
from dataset_loader.GraphCoversGeneration import GraphCoversGeneration



def dataset_loader(dataset_name, *args, **kwargs):
    if dataset_name == 'QM7':
        return QM7Dataset(*args, **kwargs)
    elif dataset_name == 'DBLP_v1':
        return DBLP_v1(*args, **kwargs)
    elif dataset_name.startswith('Letter-'):
        distorsion = dataset_name[len('Letter-'):]
        return Letter(distorsion=distorsion, **kwargs)
    elif dataset_name == 'QM9':
        return QM9Dataset(*args, **kwargs)
    elif dataset_name == 'Cover':
        return GraphCovers(*args, **kwargs)
    elif dataset_name == 'ZINC':
        return ZincDataset(*args, **kwargs)
    elif dataset_name == 'CoverGen':
        return GraphCoversGeneration(*args, **kwargs)
    else:
        raise NotImplementedError
