## Learning and Memorization in Unlearning
### Usage

To create `conda` virtual environment:
```
conda create --name <env> --file requirements.txt
```

To fine tune the model from scratch:
```bash
python main.py --config-path=configs/Qwen3-4B --config-name=finetune_1024
```

To run unlearn experiments:
```bash
python main.py --config-path=configs/Qwen3-4B --config-name=unlearn_1024
```

### Hydra configurations
#### General
- `sample_size`

#### Flags
- `compute_loss`
- `compute_acc`
- `compute_decision_boundary`
- `save_model`

#### Model configurations
- `model`
  - `base_model`
  - `pretrained_steps`
  - `lr`
  - `rc`
  - `train_batch_size`
  - `epochs`
  - `eval_every`
  - `modes`
  - `retain_dataset`
  - `unlearn_dataset`
  - `unlearn_dataset_size`
  - `checkpoints`

#### Decision boundary configuration
- `decision_boundary`
  - `grid_witdh`
  - `grid_height`
  - `grid_step_size`
  - `checkpoints`
