# Sequential Multi-agent Dynamic Algorithm Configuration

## Installation

```bash
conda create -n madac python=3.7.13
conda activate madac
pip install -r requirements.txt
pip install -e . # Local installation of madacbench Package
```

## Train Seq-MADAC

Train Seq-MADAC with MOEA/D in different tasks.

```bash
# Train
python algos/madac/main.py --config=sadn_ns --env-config=moea with env_args.key=M_2_46_3
```

Train Seq-MADAC with 10 D Seq-Sigmoid-Mask.

```bash
python algos/madac/main.py --config=sadn_sigmoid --env-config=sigmoid_state with env_args.mask=True env_args.n_agents=10
```

You can modify the relevant configuration file `algos/madac/config/envs/moea.yaml` and `algos/madac/config/algs/sadn_ns.yaml`. And you can train Seq-MADAC with different algorithms by specifying algorithm in the config (e.g., using VDN by --config=vdn_ns)

## Test Seq-MADAC

The trained model is saved in directory `results/madac/models/`, you need to specify the model directory in the configuration file via parameter `checkpoint_path`. More details of the configuration file can be found in [EPyMARL](https://github.com/uoe-agents/epymarl).

Test Seq-MA-DAC in a specific problem. (The problem set is `DTLZ2_3 DTLZ4_3 WFG4_3 WFG5_3 WFG6_3 WFG7_3 WFG8_3 WFG9_3 `) For example,

```bash
python algos/madac/main.py --config=sadn_ns_test --env-config=moea_test with env_args.key=DTLZ2_3
```

## Other Baselines

### MOEA/D

```bash
python algos/moead/moead_baseline.py
```

### DQN

Train DQN in different tasks. (The task set is `M_2_46_3, M_2_46_5, M_2_46_7`). For example, 

```
python algos/dac/dqn.py --key M_2_46_3
```

The trained model can be found in the directory `results/dqn/M_2_46_3`

The command to test the corresponding model on all problems is

```
python algos/dac/test_dqn.py --key M_2_46_3
```

## License

All the source code that has been taken from the `EPyMARL` repository was licensed (and remains so) under the Apache License v2.0 (included in `LICENSE` file). Any new code is also licensed under the Apache License v2.0.

