import numpy as np

# define finite sum objective by listing all functions


fs = np.array([[40, 0, 0],
               [20, 40, 0],
               [6, 24, 0],
               [-10, 20, 0],
               [-3, 12, 0],
               [-20, 20, 0]
                ])


def get_fbar(fs):
  assert all([len(f) == 3 for f in fs])
  return np.mean(fs, axis= 0)


def get_L(fs):
    return 2*np.max(np.abs(fs[:,0]))

print(get_fbar(fs))


# consider all functions of the form ax^2 bx + c 

def grad(f, x):
  """
    f: list of 3 values [a,b,c] that defines 
    the quadratic f
    return: derivative wrt x evaluated at x
  """
  assert len(f) == 3
  a, b, c = f[0], f[1], f[2]
  return 2*a*x + b

def eval(f,x):
  a, b, c = f[0], f[1], f[2]


def project(x):
  if x <= 0:
    return 0
  elif x >=1:
    return 1
  else:
    return x

def update(x, f, step):
  x = x - step*grad(f, x)
  return project(x)

# compute neighborhoods 

def hanzely_gd(fs, x):
    f_bar = get_fbar(fs)
    L_max = get_L(fs)
    grad_f_bar = grad(f_bar, x)
    grads = [grad(f, x) for f in fs]
    samples = [(grad_f_bar-g)**2 for g in grads]
    return np.mean(samples)

def hanzely(fs, x):
    f_bar = get_fbar(fs)
    L_max = get_L(fs)
    L = 2*np.abs(f_bar[0])
    grad_f_bar = grad(f_bar, x)
    x_tilde = update(x, f_bar, 1./L)
    x_grads = [(update(x, f, 1./L), grad(f, x)) for f in fs]
    samples = [(grad_f_bar-g)*(x-x_tilde) for (x, g) in x_grads]
    return L*np.mean(samples)

def dragomir(fs, sol):
    grads_sol = [grad(f, sol)**2 for f in fs]
    return np.mean(grads_sol)

print(hanzely(fs,1))
print(dragomir(fs, 0))