import os
import datasets
import argparse


def get_dirs(dir_path):
    return [f for f in os.listdir(dir_path) if os.path.isdir(os.path.join(dir_path, f))]


def find_files_with_prefix(directory_path, prefix):
    matching_files = []
    for filename in os.listdir(directory_path):
        if filename.startswith(prefix):
            matching_files.append(filename)
    
    return matching_files


def prepare_needed_data_fields(example, use_randomized_qa=False):

    if use_randomized_qa:
        example["question"] = example["doc"]["randomized_question"]
    else:
        example["question"] = example["doc"]["question"]

    example["answer"] = example["target"]
    example["response"] = example["resps"][0][0]

    return example


def prepare_data_for_llm_judge(dir_path):
    result_files = find_files_with_prefix(os.path.join(dir_path), 'results_')
    for result_file in result_files:
        results = datasets.load_dataset('json', data_files=os.path.join(dir_path, result_file))['train'][0]
        for benchmark in results['results']:
            benchmark_result_file = find_files_with_prefix(os.path.join(dir_path), f'samples_{benchmark}')[0]
            benchmark_results = datasets.load_dataset('json', data_files=os.path.join(dir_path, benchmark_result_file))['train']
            dataset_for_llm_judge = benchmark_results.map(prepare_needed_data_fields, remove_columns=[k for k in benchmark_results.features], fn_kwargs={"use_randomized_qa": True if benchmark.startswith("cap") else False})
            save_dir_for_dataset_for_llm_judge = os.path.join("/".join(dir_path.split("/")[:-2]), "llm_judge", dir_path.split("/")[-1])
            dataset_for_llm_judge.to_json(
                os.path.join(save_dir_for_dataset_for_llm_judge, f"samples_{benchmark}.json")
            )

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--lm_eval_harness_results_path", type=str)
    args = parser.parse_args()

    prepare_data_for_llm_judge(args.lm_eval_harness_results_path)