export CUDA_VISIBLE_DEVICES="1"
export OMP_NUM_THREADS="4"
export MKL_NUM_THREADS="4"
export NUMEXPR_NUM_THREADS="4"
export OPENBLAS_NUM_THREADS="4"


#!/bin/bash
DATA=/datasets/OfficeHome
DATASET=office_home_dg
D1=art
D2=clipart
D3=product
D4=real_world
SEED=3407
method=ce+ua+nocoefunkfda_epoch30_0.05p
output_dir=./results
fda_loss_coef=1
penalty_coef=0.05
warmup_epoch=0
topk=1
ua_loss_coef=1
ua_loss_coef1=0
smooth_coef=1
bs=64
lr=0.01
epochs=30

# DA
tta_epoch=1
tta_lr=0.001
adv_grl=0.1
tta_ce_coef=0.05
tta_sc_coef=0
dsname=res_DM_${DATASET}_ConvNet_10ipc.pt



python tools/train_mytest.py \
--root ${DATA} \
--trainer Vanilla_Ada \
--evaluator Classification_plain \
--fda_loss_coef ${fda_loss_coef} \
--ua_loss_coef ${ua_loss_coef} \
--ua_loss_coef1 ${ua_loss_coef1} \
--penalty_coef ${penalty_coef} \
--warmup_epoch ${warmup_epoch} \
--smooth_coef ${smooth_coef} \
--adv_grl ${adv_grl} \
--tta_lr ${tta_lr} \
--tta_epoch ${tta_epoch} \
--topk ${topk} \
--source-domains ${D1} \
--target-domains ${D2} \
--seed ${SEED} \
--bs ${bs} \
--lr ${lr} \
--epochs ${epochs} \
--dataset-config-file /configs/datasets/dg/${DATASET}.yaml \
--config-file /configs/trainers/dg/vanilla/${DATASET}.yaml \
--output-dir ${output_dir}/${DATASET}/${method}/${D1}-${D2} \
--only_train


python tools/train_mytest.py \
--root ${DATA} \
--trainer Vanilla_Ada \
--evaluator Classification_plain \
--fda_loss_coef ${fda_loss_coef} \
--ua_loss_coef ${ua_loss_coef} \
--ua_loss_coef1 ${ua_loss_coef1} \
--penalty_coef ${penalty_coef} \
--warmup_epoch ${warmup_epoch} \
--smooth_coef ${smooth_coef} \
--adv_grl ${adv_grl} \
--tta_lr ${tta_lr} \
--tta_epoch ${tta_epoch} \
--topk ${topk} \
--source-domains ${D2} \
--target-domains ${D1} \
--seed ${SEED} \
--bs ${bs} \
--lr ${lr} \
--epochs ${epochs} \
--dataset-config-file /configs/datasets/dg/${DATASET}.yaml \
--config-file /configs/trainers/dg/vanilla/${DATASET}.yaml \
--output-dir ${output_dir}/${DATASET}/${method}/${D2}-${D1} \
--only_train


python tools/train_mytest.py \
--root ${DATA} \
--trainer Vanilla_Ada \
--evaluator Classification_plain \
--fda_loss_coef ${fda_loss_coef} \
--ua_loss_coef ${ua_loss_coef} \
--ua_loss_coef1 ${ua_loss_coef1} \
--penalty_coef ${penalty_coef} \
--warmup_epoch ${warmup_epoch} \
--smooth_coef ${smooth_coef} \
--adv_grl ${adv_grl} \
--tta_lr ${tta_lr} \
--tta_epoch ${tta_epoch} \
--topk ${topk} \
--source-domains ${D3} \
--target-domains ${D1} \
--seed ${SEED} \
--bs ${bs} \
--lr ${lr} \
--epochs ${epochs} \
--dataset-config-file /configs/datasets/dg/${DATASET}.yaml \
--config-file /configs/trainers/dg/vanilla/${DATASET}.yaml \
--output-dir ${output_dir}/${DATASET}/${method}/${D3}-${D1} \
--only_train



python tools/train_mytest.py \
--root ${DATA} \
--trainer Vanilla_Ada \
--evaluator Classification_plain \
--fda_loss_coef ${fda_loss_coef} \
--ua_loss_coef ${ua_loss_coef} \
--ua_loss_coef1 ${ua_loss_coef1} \
--penalty_coef ${penalty_coef} \
--warmup_epoch ${warmup_epoch} \
--smooth_coef ${smooth_coef} \
--adv_grl ${adv_grl} \
--tta_lr ${tta_lr} \
--tta_epoch ${tta_epoch} \
--topk ${topk} \
--source-domains ${D4} \
--target-domains ${D1} \
--seed ${SEED} \
--bs ${bs} \
--lr ${lr} \
--epochs ${epochs} \
--dataset-config-file /configs/datasets/dg/${DATASET}.yaml \
--config-file /configs/trainers/dg/vanilla/${DATASET}.yaml \
--output-dir ${output_dir}/${DATASET}/${method}/${D4}-${D1} \
--only_train



echo "Copying directories..."
cp -r ${output_dir}/${DATASET}/${method}/${D1}-${D2} ${output_dir}/${DATASET}/${method}/${D1}-${D3}
cp -r ${output_dir}/${DATASET}/${method}/${D1}-${D2} ${output_dir}/${DATASET}/${method}/${D1}-${D4}
cp -r ${output_dir}/${DATASET}/${method}/${D2}-${D1} ${output_dir}/${DATASET}/${method}/${D2}-${D3}
cp -r ${output_dir}/${DATASET}/${method}/${D2}-${D1} ${output_dir}/${DATASET}/${method}/${D2}-${D4}
cp -r ${output_dir}/${DATASET}/${method}/${D3}-${D1} ${output_dir}/${DATASET}/${method}/${D3}-${D4}
cp -r ${output_dir}/${DATASET}/${method}/${D3}-${D1} ${output_dir}/${DATASET}/${method}/${D3}-${D2}
cp -r ${output_dir}/${DATASET}/${method}/${D4}-${D1} ${output_dir}/${DATASET}/${method}/${D4}-${D3}
cp -r ${output_dir}/${DATASET}/${method}/${D4}-${D1} ${output_dir}/${DATASET}/${method}/${D4}-${D2}


