export CUDA_VISIBLE_DEVICES="0"
export OMP_NUM_THREADS="4"
export MKL_NUM_THREADS="4"
export NUMEXPR_NUM_THREADS="4"
export OPENBLAS_NUM_THREADS="4"


DATA=/datasets/OfficeHomeori
DATASET=office_home_dg
D1=art
D2=clipart
D3=product
D4=real_world
SEED=3407
method=ce+ua+nocoefunkfda_epoch30_0.05p
output_dir=./results
fda_loss_coef=1
penalty_coef=0.05
warmup_epoch=0
topk=1
ua_loss_coef=1
ua_loss_coef1=0
smooth_coef=1
bs=32
lr=0.01
epochs=30

# DA
tta_epoch=0
tta_lr=0.001
adv_grl=0.1


# DM params
RESUME=/${output_dir}/${DATASET}/${method}/${D1}-${D2}/backbone/model.pth.tar-${epochs}
RESUME_C=/${output_dir}/${DATASET}/${method}/${D1}-${D2}/classifier/model.pth.tar-${epochs}

python main_DM_ada.py \
--root ${DATA} \
--trainer Vanilla_ada \
--evaluator Classification_plain \
--fda_loss_coef ${fda_loss_coef} \
--ua_loss_coef ${ua_loss_coef} \
--ua_loss_coef1 ${ua_loss_coef1} \
--penalty_coef ${penalty_coef} \
--warmup_epoch ${warmup_epoch} \
--smooth_coef ${smooth_coef} \
--adv_grl ${adv_grl} \
--tta_lr ${tta_lr} \
--tta_epoch ${tta_epoch} \
--topk ${topk} \
--source-domains ${D1} \
--target-domains ${D2} \
--seed ${SEED} \
--bs ${bs} \
--lr ${lr} \
--epochs ${epochs} \
--dataset-config-file /configs/datasets/dg/${DATASET}.yaml \
--config-file /configs/trainers/dg/vanilla/${DATASET}.yaml \
--output-dir ${output_dir}/${DATASET}/${method}/${D1} \
--dsa_strategy crop_scale_rotate \
--init noise \
--data_path ${DATA} \
--num_exp 1 \
--num_eval 1 \
--style-norm-realonly \
--pretrained \
--loss_weight 1.0 \
--lr_img 5.0 \
--DM_dataset ${DATASET} \
--save_path ${output_dir}/${DATASET}/${method}/${D1} \
--Iteration 10000 \
--norm-layer 2 \
--batch_real 15 \
--resume_path ${RESUME} \
--resume_classifier_path ${RESUME_C} \
--ipc 10

