# CondPINN
Preconditioning for Physics-Informed Neural Network

# Directory Tree

- `data/` (from the [PINNacle](https://github.com/i207M/PINNacle/tree/main) benchmark)
    - `ref/` reference solutions of the PDE problems.
    - `param/` parameter data of the PDE problems.

- `logs/` running logs, plots, and saved models. Each run corresponds to a unique folder with a name: date + time + problem name + round number.

- `src/` source codes.

- `utils/` utilities.

- `runs/` auto generated running logs (stderr / stdout / etc...) for parallel training

- `scripts/` scripts for plotting and running experiments.

# Getting Started

Download and install necessary dependencies:

```bash
# Make sure that you are in the root directory of this repo
source setup.sh
```

# Issues

If GPU memory is your bottleneck, try to set `"Use Sparse Solver" = true` in the configuration.

# Run

## PCPINN Experiments

To start a training of a single task, run the following command:

```bash
python main.py --case [CaseName]
```

for example, if you want to start a Burgers1d_C experiment, use:

```bash
python main.py --case Burgers1d_C
```

To start a parallel training of all tasks in the main experiment, please use the following command:

```bash
python main_batch.py --name [Experiment Name] --repeat [Repeat times for each experiments]
```

the runner will auto start multiple processes in different gpus. 

## Experiments in Section 5.2

To calculate condition number using a neural network method, run the following command:

```bash
cd scripts
python nncond.py --case [wave / poisson]
```

for FDM method, run:

```bash
cd scripts
python thycond.py --case [burger / wave / poisson / helmholtz]
```

for using vanilla PINN to train the case under different method, run:

```bash
cd scripts
python train.py --case [wave / helmholtz / burger]
```


## Plotting Figure 1
```bash
python -m scripts.plot_errorlandscape
```

## Solving Inverse Problems by Adjoint Method
```bash
# Poisson Inverse Problem (PInv)
python -m scripts.solve_pinv
# Heat Inverse Problem (HInv)
python -m scripts.solve_hinv
```