import json

from src.nlrunner import NonLinearPDERunner
from src.burgers.burgers1d_c.pdedata import Burgers1D_C


class Burgers1D_CRunner(NonLinearPDERunner):
    """
    Run the 1D Burgers' equation (Burgers1d-C).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Burgers1D_C()
    
    def load_config(self):
        # Load from json file
        with open("src/burgers/burgers1d_c/conf.json", "r") as f:
            self.config = json.load(f)
