import json

from src.tmrunner import TimeSteppingRunner
from src.chaotic.gs.pdedata import GS
from utils.mlp import MLP


class GSRunner(TimeSteppingRunner):
    """
    Run the 2D Diffusion-Reaction Gray-ScottModel (GS).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = GS()
    
    def load_config(self):
        # Load from json file
        with open("src/chaotic/gs/conf.json", "r") as f:
            self.config = json.load(f)
    
    def init_model(self):
        self.model = MLP(
            layer_sizes=[self.config["Spatial Dimension"]] + 
            [128] * 5 + [self.config["Output Dimension"]* 
                self.config["Grid Size (t-direction)"]]).to(self.device)

