import json

from src.tmrunner import TimeSteppingRunner
from src.chaotic.ks.pdedata import KS
from utils.mlp import MLP


class KSRunner(TimeSteppingRunner):
    """
    Run the 2D Diffusion-Reaction Kuramoto-Sivashinsky Model (KS).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = KS()
    
    def load_config(self):
        # Load from json file
        with open("src/chaotic/ks/conf.json", "r") as f:
            self.config = json.load(f)
    
    def init_model(self):
        self.model = MLP(
            layer_sizes=[self.config["Spatial Dimension"]] + 
            [128] * 5 + [self.config["Output Dimension"]* 
                self.config["Grid Size (t-direction)"]]).to(self.device)

    def setup(self):
        super().setup()
        self.X.requires_grad_(True)
