import json

from src.runner import RunnerBase
from src.heat.heat2d_cg.pdedata import Heat2D_CG


class Heat2D_CGRunner(RunnerBase):
    """
    Run the 2D Heat equation (Heat2d-CG).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Heat2D_CG()
    
    def load_config(self):
        # Load from json file
        with open("src/heat/heat2d_cg/conf.json", "r") as f:
            self.config = json.load(f)
