import json

from src.tmrunner import TimeSteppingRunner
from src.heat.heat2d_lt.pdedata import Heat2D_LT
from utils.mlp import MLP


class Heat2D_LTRunner(TimeSteppingRunner):
    """
    Run the 2D heat equation (Heat2d-LT).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Heat2D_LT()
    
    def load_config(self):
        # Load from json file
        with open("src/heat/heat2d_lt/conf.json", "r") as f:
            self.config = json.load(f)

    def init_model(self):
        self.model = MLP(
            layer_sizes=[self.config["Spatial Dimension"]] + 
            [128] * 5 + [self.config["Output Dimension"]* 
                self.config["Grid Size (t-direction)"]]).to(self.device)
