import json

from src.runner import RunnerBase
from src.heat.heat2d_ms.pdedata import Heat2D_MS
from utils.mlp import MLP


class Heat2D_MSRunner(RunnerBase):
    """
    Run the 2D heat equation (Heat2d-MS).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Heat2D_MS()
    
    def load_config(self):
        # Load from json file
        with open("src/heat/heat2d_ms/conf.json", "r") as f:
            self.config = json.load(f)
    
    def init_model(self):
        self.model = MLP(
            layer_sizes=[self.config["Spatial Temporal Dimension"]] + 
            [128] * 5 + [self.config["Output Dimension"]]).to(self.device)
