import json

from src.runner import RunnerBase
from src.heat.heat2d_vc.pdedata import Heat2D_VC
from utils.fourier_mlp import FourierMLP


class Heat2D_VCRunner(RunnerBase):
    """
    Run the 2D heat equation (Heat2d-VC).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Heat2D_VC()
    
    def load_config(self):
        # Load from json file
        with open("src/heat/heat2d_vc/conf.json", "r") as f:
            self.config = json.load(f)
    
    def init_model(self):
        self.model = FourierMLP(
            input_dim=self.config["Spatial Temporal Dimension"],
            output_dim=self.config["Output Dimension"],
            n_layers=5, n_hidden=128, _type='gaussian', 
            fourier_dim=128, sigma=0.5).to(self.device)
