from src.pdedata import PDEDataBase


class NonLinearPDEData(PDEDataBase):
    """
    Prepare data for the non-linear PDEs.
    """
    def set_u_data(self, u_data):
        """
        Set the data for the current solution,
        which is used for computing the residual F(u) and 
        the Jacobian F'(u) in the Newton iteration.

        Note: `u_data` will be converted to a 1D Numpy array.
        """
        if self.config["Output Dimension"] == 1:
            self.u_data = u_data
        else:
            self.u_data = self.rearrange_u_data(u_data)
        self.u_data = self.u_data.reshape(-1)
    
    def init_newton_system(self):
        """
        Initialize the Newton system F'(u) delta_u = -F(u).
        F'(u) will be stored in self.A and 
        -F(u) will be stored in self.b.

        Note: make sure to call `set_u_data()` before 
        calling this function.
        """
        raise NotImplementedError("init_newton_system() is not implemented.")

    def setup(self, config: dict):
        self.config = config
        self.init_problem()
        self.prepare_test_data()
    
    def setup_newton(self, u_data):
        """
        Setup for the Newton iteration.
        `u_data` is the current solution.
        """
        self.set_u_data(u_data)
        self.init_newton_system()
        if self.config["Use Preconditioner"]:
            self.init_precond()
