import json

from src.nlrunner import NonLinearPDERunner
from src.ns.ns2d_cg.pdedata import NS2D_CG


class NS2D_CGRunner(NonLinearPDERunner):
    """
    Run the 2D Navier-Stokes equation (NS2D_CG).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = NS2D_CG()
    
    def load_config(self):
        # Load from json file
        with open("src/ns/ns2d_cg/conf.json", "r") as f:
            self.config = json.load(f)
