import json

from src.runner import RunnerBase
from src.poisson.poisson2d_c.pdedata import Poisson2D_C


class Poisson2D_CRunner(RunnerBase):
    """
    Run the 2D Poisson equation (Poisson2d-C).
    """

    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Poisson2D_C()

    def load_config(self):
        # Load from json file
        with open("src/poisson/poisson2d_c/conf.json", "r") as f:
            self.config = json.load(f)
