import json

from src.runner import RunnerBase
from src.poisson.poisson2d_cg.pdedata import Poisson2D_CG


class Poisson2D_CGRunner(RunnerBase):
    """
    Run the 2D Poisson equation (Poisson2d-CG).
    """

    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Poisson2D_CG()

    def load_config(self):
        # Load from json file
        with open("src/poisson/poisson2d_cg/conf.json", "r") as f:
            self.config = json.load(f)