import json

from src.runner import RunnerBase
from src.poisson.poisson3d_cg.pdedata import Poisson3D_CG


class Poisson3D_CGRunner(RunnerBase):
    """
    Run the 3D Poisson equation (Poisson3d-CG).
    """

    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Poisson3D_CG()

    def load_config(self):
        # Load from json file
        with open("src/poisson/poisson3d_cg/conf.json", "r") as f:
            self.config = json.load(f)
