import json

from src.runner import RunnerBase
from src.wave.wave1d_c.pdedata import Wave1D_C


class Wave1D_CRunner(RunnerBase):
    """
    Run the 1D wave equation (Wave1d-C).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Wave1D_C()
    
    def load_config(self):
        # Load from json file
        with open("src/wave/wave1d_c/conf.json", "r") as f:
            self.config = json.load(f)
