import json

from src.runner import RunnerBase
from src.wave.wave2d_ms.pdedata import Wave2D_MS
from utils.fourier_mlp import FourierMLP


class Wave2D_MSRunner(RunnerBase):
    """
    Run the 2D wave equation (Wave2d-MS).
    """
    def __init__(self, device="cuda") -> None:
        super().__init__(device=device)
        self.pde_data = Wave2D_MS()
    
    def load_config(self):
        # Load from json file
        with open("src/wave/wave2d_ms/conf.json", "r") as f:
            self.config = json.load(f)
    
    def init_model(self):
        self.model = FourierMLP(
            input_dim=self.config["Spatial Temporal Dimension"],
            output_dim=self.config["Output Dimension"],
            n_layers=5, n_hidden=128, _type='gaussian', 
            fourier_dim=128, sigma=0.5).to(self.device)
