#!/usr/bin/env bash

set -x

PARTITION=$1
CFG=$2
CHECKPOINT=$3
GPUS=${GPUS:-4}
GPUS_PER_NODE=${GPUS_PER_NODE:-4}
CPUS_PER_TASK=${CPUS_PER_TASK:-5}
SRUN_ARGS=${SRUN_ARGS:-""}
PY_ARGS=${@:4}

PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
mim test mmseg \
    $CFG \
    --checkpoint $CHECKPOINT \
    --launcher slurm -G $GPUS \
    --gpus-per-node $GPUS_PER_NODE \
    --cpus-per-task $CPUS_PER_TASK \
    --partition $PARTITION \
    --srun-args "$SRUN_ARGS" \
    $PY_ARGS
