# Copyright (c) OpenMMLab. All rights reserved.
# This is a BETA new format config file, and the usage may change recently.
from mmpretrain.models import (GlobalAveragePooling, ImageClassifier,
                               LabelSmoothLoss, LinearClsHead,
                               SwinTransformerV2)

# model settings
model = dict(
    type=ImageClassifier,
    backbone=dict(
        type=SwinTransformerV2, arch='base', img_size=384, drop_path_rate=0.2),
    neck=dict(type=GlobalAveragePooling),
    head=dict(
        type=LinearClsHead,
        num_classes=1000,
        in_channels=1024,
        init_cfg=None,  # suppress the default init_cfg of LinearClsHead.
        loss=dict(type=LabelSmoothLoss, label_smooth_val=0.1, mode='original'),
        cal_acc=False))
